/*
 * Decompiled with CFR 0.152.
 */
package org.wildfly.camel.test.jndi;

import javax.naming.Context;
import javax.naming.InitialContext;
import javax.naming.NamingException;
import org.apache.camel.ProducerTemplate;
import org.apache.camel.RoutesBuilder;
import org.apache.camel.builder.RouteBuilder;
import org.jboss.arquillian.container.test.api.Deployment;
import org.jboss.arquillian.junit.Arquillian;
import org.jboss.arquillian.test.api.ArquillianResource;
import org.jboss.gravia.runtime.ServiceLocator;
import org.jboss.shrinkwrap.api.ShrinkWrap;
import org.jboss.shrinkwrap.api.spec.JavaArchive;
import org.junit.Assert;
import org.junit.Test;
import org.junit.runner.RunWith;
import org.wildfly.camel.test.common.types.HelloBean;
import org.wildfly.extension.camel.CamelAware;
import org.wildfly.extension.camel.CamelContextFactory;
import org.wildfly.extension.camel.WildFlyCamelContext;

@CamelAware
@RunWith(value=Arquillian.class)
public class JNDIIntegrationTest {
    @Deployment
    public static JavaArchive deployment() {
        JavaArchive archive = (JavaArchive)ShrinkWrap.create(JavaArchive.class, (String)"jndi-integration-tests");
        archive.addClasses(new Class[]{HelloBean.class});
        return archive;
    }

    @Test
    public void testArquillianResource(@ArquillianResource CamelContextFactory contextFactory) throws Exception {
        WildFlyCamelContext camelctx = contextFactory.createCamelContext();
        this.assertBeanBinding(camelctx);
    }

    @Test
    public void testCamelContextFactoryLookup() throws Exception {
        InitialContext inicxt = new InitialContext();
        CamelContextFactory factory = (CamelContextFactory)inicxt.lookup("java:jboss/camel/CamelContextFactory");
        WildFlyCamelContext camelctx = factory.createCamelContext();
        this.assertBeanBinding(camelctx);
    }

    @Test
    public void testCamelContextFactoryService() throws Exception {
        CamelContextFactory contextFactory = (CamelContextFactory)ServiceLocator.getRequiredService(CamelContextFactory.class);
        WildFlyCamelContext camelctx = contextFactory.createCamelContext(this.getClass().getClassLoader());
        this.assertBeanBinding(camelctx);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void assertBeanBinding(WildFlyCamelContext camelctx) throws NamingException, Exception {
        Context jndictx = camelctx.getNamingContext();
        jndictx.bind("helloBean", (Object)new HelloBean());
        try {
            camelctx.addRoutes((RoutesBuilder)new RouteBuilder(){

                public void configure() throws Exception {
                    this.from("direct:start").bean((Object)"helloBean");
                }
            });
            camelctx.start();
            try {
                ProducerTemplate producer = camelctx.createProducerTemplate();
                String result = (String)producer.requestBody("direct:start", (Object)"Kermit", String.class);
                Assert.assertEquals((Object)"Hello Kermit", (Object)result);
            }
            finally {
                camelctx.stop();
            }
        }
        finally {
            jndictx.unbind("helloBean");
        }
    }
}

