/*
 * Decompiled with CFR 0.152.
 */
package org.wildfly.camel.test.sql;

import java.io.IOException;
import java.util.Map;
import javax.annotation.Resource;
import javax.sql.DataSource;
import org.apache.camel.CamelContext;
import org.apache.camel.Expression;
import org.apache.camel.PollingConsumer;
import org.apache.camel.ProducerTemplate;
import org.apache.camel.RoutesBuilder;
import org.apache.camel.builder.RouteBuilder;
import org.apache.camel.component.mock.MockEndpoint;
import org.apache.camel.impl.DefaultCamelContext;
import org.apache.camel.processor.idempotent.jdbc.JdbcMessageIdRepository;
import org.apache.camel.spi.IdempotentRepository;
import org.jboss.arquillian.container.test.api.Deployer;
import org.jboss.arquillian.container.test.api.Deployment;
import org.jboss.arquillian.junit.Arquillian;
import org.jboss.arquillian.test.api.ArquillianResource;
import org.jboss.shrinkwrap.api.ShrinkWrap;
import org.jboss.shrinkwrap.api.asset.Asset;
import org.jboss.shrinkwrap.api.asset.EmptyAsset;
import org.jboss.shrinkwrap.api.spec.JavaArchive;
import org.junit.Assert;
import org.junit.Test;
import org.junit.runner.RunWith;
import org.wildfly.camel.test.sql.subA.CdiRouteBuilder;
import org.wildfly.extension.camel.CamelAware;
import org.wildfly.extension.camel.CamelContextRegistry;

@CamelAware
@RunWith(value=Arquillian.class)
public class SQLIntegrationTest {
    private static final String CAMEL_SQL_CDI_ROUTES_JAR = "camel-sql-cdi-routes.jar";
    @ArquillianResource
    CamelContextRegistry contextRegistry;
    @ArquillianResource
    Deployer deployer;
    @Resource(name="java:jboss/datasources/ExampleDS")
    DataSource dataSource;

    @Deployment
    public static JavaArchive createDeployment() throws IOException {
        JavaArchive archive = (JavaArchive)ShrinkWrap.create(JavaArchive.class, (String)"camel-sql-tests.jar");
        archive.addAsManifestResource((Asset)EmptyAsset.INSTANCE, "beans.xml");
        return archive;
    }

    @Deployment(managed=false, name="camel-sql-cdi-routes.jar")
    public static JavaArchive createCDIDeployment() throws IOException {
        JavaArchive archive = (JavaArchive)ShrinkWrap.create(JavaArchive.class, (String)CAMEL_SQL_CDI_ROUTES_JAR);
        archive.addPackage(CdiRouteBuilder.class.getPackage());
        archive.addAsManifestResource((Asset)EmptyAsset.INSTANCE, "beans.xml");
        return archive;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    public void testSQLEndpoint() throws Exception {
        Assert.assertNotNull((String)"DataSource not null", (Object)this.dataSource);
        DefaultCamelContext camelctx = new DefaultCamelContext();
        camelctx.addRoutes((RoutesBuilder)new RouteBuilder(){

            public void configure() throws Exception {
                this.from("sql:select name from information_schema.users?dataSource=java:jboss/datasources/ExampleDS").to("direct:end");
            }
        });
        camelctx.start();
        try {
            PollingConsumer pollingConsumer = camelctx.getEndpoint("direct:end").createPollingConsumer();
            pollingConsumer.start();
            String result = (String)((Map)pollingConsumer.receive().getIn().getBody(Map.class)).get("NAME");
            Assert.assertEquals((Object)"SA", (Object)result);
        }
        finally {
            camelctx.stop();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    public void testSQLEndpointWithCDIContext() throws Exception {
        try {
            this.deployer.deploy(CAMEL_SQL_CDI_ROUTES_JAR);
            CamelContext camelctx = this.contextRegistry.getCamelContext("camel-sql-cdi-context");
            Assert.assertNotNull((String)"Camel context not null", (Object)camelctx);
            PollingConsumer pollingConsumer = camelctx.getEndpoint("direct:end").createPollingConsumer();
            pollingConsumer.start();
            String result = (String)((Map)pollingConsumer.receive().getIn().getBody(Map.class)).get("NAME");
            Assert.assertEquals((Object)"SA", (Object)result);
        }
        finally {
            this.deployer.undeploy(CAMEL_SQL_CDI_ROUTES_JAR);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    public void testSqlIdempotentConsumer() throws Exception {
        Assert.assertNotNull((String)"DataSource not null", (Object)this.dataSource);
        final JdbcMessageIdRepository jdbcMessageIdRepository = new JdbcMessageIdRepository(this.dataSource, "myProcessorName");
        DefaultCamelContext camelctx = new DefaultCamelContext();
        camelctx.addRoutes((RoutesBuilder)new RouteBuilder(){

            public void configure() throws Exception {
                this.from("direct:start").idempotentConsumer((Expression)this.simple("${header.messageId}"), (IdempotentRepository)jdbcMessageIdRepository).to("mock:result");
            }
        });
        camelctx.start();
        try {
            MockEndpoint mockEndpoint = (MockEndpoint)camelctx.getEndpoint("mock:result", MockEndpoint.class);
            mockEndpoint.expectedMessageCount(1);
            ProducerTemplate template = camelctx.createProducerTemplate();
            for (int i = 0; i < 5; ++i) {
                template.requestBodyAndHeader("direct:start", null, "messageId", (Object)"12345");
            }
            mockEndpoint.assertIsSatisfied();
        }
        finally {
            camelctx.stop();
        }
    }
}

