/*
 * Decompiled with CFR 0.152.
 */
package org.wildfly.camel.test.zipfile;

import java.io.BufferedReader;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.FileWriter;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.util.Iterator;
import java.util.zip.ZipEntry;
import java.util.zip.ZipFile;
import java.util.zip.ZipOutputStream;
import org.apache.camel.Expression;
import org.apache.camel.PollingConsumer;
import org.apache.camel.ProducerTemplate;
import org.apache.camel.RoutesBuilder;
import org.apache.camel.builder.RouteBuilder;
import org.apache.camel.dataformat.zipfile.ZipSplitter;
import org.apache.camel.impl.DefaultCamelContext;
import org.apache.camel.model.DataFormatDefinition;
import org.apache.camel.model.ExpressionNode;
import org.apache.camel.model.RouteDefinition;
import org.apache.camel.model.dataformat.ZipFileDataFormat;
import org.jboss.arquillian.container.test.api.Deployment;
import org.jboss.arquillian.junit.Arquillian;
import org.jboss.shrinkwrap.api.ShrinkWrap;
import org.jboss.shrinkwrap.api.spec.WebArchive;
import org.junit.Assert;
import org.junit.Test;
import org.junit.runner.RunWith;
import org.wildfly.extension.camel.CamelAware;

@CamelAware
@RunWith(value=Arquillian.class)
public class ZipFileIntegrationTest {
    private String datadir = System.getProperty("jboss.server.data.dir");

    @Deployment
    public static WebArchive createDeployment() {
        WebArchive archive = (WebArchive)ShrinkWrap.create(WebArchive.class, (String)"zipfile-tests.war");
        return archive;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    public void testZipFileMarshal() throws Exception {
        DefaultCamelContext camelctx = new DefaultCamelContext();
        camelctx.addRoutes((RoutesBuilder)new RouteBuilder(){

            public void configure() throws Exception {
                ((RouteDefinition)this.from("direct:start").setHeader("CamelFileName", (Expression)this.constant("test.txt"))).marshal().zipFile().to("file://" + ZipFileIntegrationTest.this.datadir + File.separator + "zip-marshal");
            }
        });
        camelctx.start();
        try {
            ProducerTemplate producer = camelctx.createProducerTemplate();
            producer.sendBody("direct:start", (Object)"Hello Kermit");
            ZipFile zip = new ZipFile(this.datadir + "/zip-marshal/test.txt.zip");
            Assert.assertNotNull((Object)zip);
            Assert.assertTrue((zip.size() > 0 ? 1 : 0) != 0);
            ZipEntry entry = zip.getEntry("test.txt");
            String zipFileContent = this.getZipFileContent(zip.getInputStream(entry));
            Assert.assertEquals((Object)"Hello Kermit", (Object)zipFileContent);
        }
        finally {
            camelctx.stop();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    public void testZipFileUnmarshal() throws Exception {
        final ZipFileDataFormat zipFileDataFormat = new ZipFileDataFormat();
        zipFileDataFormat.setUsingIterator(Boolean.valueOf(true));
        DefaultCamelContext camelctx = new DefaultCamelContext();
        camelctx.addRoutes((RoutesBuilder)new RouteBuilder(){

            public void configure() throws Exception {
                ((ExpressionNode)((RouteDefinition)this.from("file://" + ZipFileIntegrationTest.this.datadir + File.separator + "zip-unmarshal?consumer.delay=1000&antInclude=*.zip&noop=true").unmarshal((DataFormatDefinition)zipFileDataFormat)).split((Expression)this.bodyAs(Iterator.class)).streaming().convertBodyTo(String.class)).to("direct:end");
            }
        });
        this.createZipFile("Hello Kermit");
        camelctx.start();
        try {
            PollingConsumer pollingConsumer = camelctx.getEndpoint("direct:end").createPollingConsumer();
            pollingConsumer.start();
            String result = (String)pollingConsumer.receive().getIn().getBody(String.class);
            Assert.assertEquals((Object)"Hello Kermit", (Object)result);
        }
        finally {
            camelctx.stop();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    public void testZipSplitterUnmarshal() throws Exception {
        DefaultCamelContext camelctx = new DefaultCamelContext();
        camelctx.addRoutes((RoutesBuilder)new RouteBuilder(){

            public void configure() throws Exception {
                ((ExpressionNode)this.from("file://" + ZipFileIntegrationTest.this.datadir + File.separator + "zip-unmarshal?consumer.delay=1000&antInclude=*.zip&noop=true").split((Expression)new ZipSplitter()).streaming().convertBodyTo(String.class)).to("direct:end");
            }
        });
        this.createZipFile("Hello Kermit");
        camelctx.start();
        try {
            PollingConsumer pollingConsumer = camelctx.getEndpoint("direct:end").createPollingConsumer();
            pollingConsumer.start();
            String result = (String)pollingConsumer.receive().getIn().getBody(String.class);
            Assert.assertEquals((Object)"Hello Kermit", (Object)result);
        }
        finally {
            camelctx.stop();
        }
    }

    private String getZipFileContent(InputStream inputStream) {
        StringBuilder content = new StringBuilder();
        try (BufferedReader reader = new BufferedReader(new InputStreamReader(inputStream));){
            String line;
            while ((line = reader.readLine()) != null) {
                content.append(line);
            }
        }
        catch (IOException e) {
            e.printStackTrace();
        }
        return content.toString();
    }

    private void createZipFile(String content) throws IOException {
        String basePath = this.datadir + File.separator + "zip-unmarshal" + File.separator;
        File file = new File(basePath + "test.txt");
        file.getParentFile().mkdirs();
        try (FileWriter fw = new FileWriter(file);
             FileOutputStream fos = new FileOutputStream(basePath + "test.zip");
             ZipOutputStream zos = new ZipOutputStream(fos);
             FileInputStream fis = new FileInputStream(basePath + "test.txt");){
            int len;
            fw.write(content);
            fw.close();
            ZipEntry entry = new ZipEntry("test.txt");
            zos.putNextEntry(entry);
            byte[] buffer = new byte[1024];
            while ((len = fis.read(buffer)) > 0) {
                zos.write(buffer, 0, len);
            }
            zos.closeEntry();
        }
    }
}

