/*
 * Decompiled with CFR 0.152.
 */
package org.wildfly.camel.test.cdi;

import java.util.ArrayList;
import java.util.List;
import org.apache.camel.CamelContext;
import org.apache.camel.spi.CamelContextTracker;
import org.jboss.arquillian.container.test.api.Deployer;
import org.jboss.arquillian.container.test.api.Deployment;
import org.jboss.arquillian.junit.Arquillian;
import org.jboss.arquillian.test.api.ArquillianResource;
import org.jboss.shrinkwrap.api.ShrinkWrap;
import org.jboss.shrinkwrap.api.asset.Asset;
import org.jboss.shrinkwrap.api.asset.EmptyAsset;
import org.jboss.shrinkwrap.api.spec.JavaArchive;
import org.junit.Assert;
import org.junit.Test;
import org.junit.runner.RunWith;
import org.wildfly.camel.test.cdi.subC.InjectedContextBean;
import org.wildfly.extension.camel.CamelAware;
import org.wildfly.extension.camel.CamelContextRegistry;

@CamelAware
@RunWith(value=Arquillian.class)
public class CDIContextCreationIntegrationTest {
    private static final String CDI_CONTEXT_A = "cdi-context-a.jar";
    private static final String CDI_CONTEXT_B = "cdi-context-b.jar";
    @ArquillianResource
    private Deployer deployer;
    @ArquillianResource
    private CamelContextRegistry contextRegistry;

    @Deployment
    public static JavaArchive createDeployment() {
        return (JavaArchive)ShrinkWrap.create(JavaArchive.class);
    }

    @Test
    public void testCDIContextCreation() throws InterruptedException {
        try (FakeContextTracker tracker = new FakeContextTracker();){
            tracker.open();
            Assert.assertEquals((long)0L, (long)tracker.getContextCount());
            Assert.assertEquals((long)0L, (long)this.contextRegistry.getCamelContexts().size());
            this.deployer.deploy(CDI_CONTEXT_A);
            Assert.assertEquals((long)1L, (long)tracker.getContextCount());
            Assert.assertEquals((long)1L, (long)this.contextRegistry.getCamelContexts().size());
            this.deployer.deploy(CDI_CONTEXT_B);
            Assert.assertEquals((long)2L, (long)tracker.getContextCount());
            Assert.assertEquals((long)2L, (long)this.contextRegistry.getCamelContexts().size());
            this.deployer.undeploy(CDI_CONTEXT_A);
            this.deployer.undeploy(CDI_CONTEXT_B);
            Assert.assertEquals((long)0L, (long)this.contextRegistry.getCamelContexts().size());
        }
    }

    @Deployment(name="cdi-context-a.jar", managed=false, testable=false)
    public static JavaArchive createCdiTestJar() {
        JavaArchive archive = (JavaArchive)ShrinkWrap.create(JavaArchive.class, (String)CDI_CONTEXT_A);
        archive.addAsManifestResource((Asset)EmptyAsset.INSTANCE, "beans.xml");
        archive.addPackage(InjectedContextBean.class.getPackage());
        return archive;
    }

    @Deployment(name="cdi-context-b.jar", managed=false, testable=false)
    public static JavaArchive createOtherCdiTestJar() {
        JavaArchive archive = (JavaArchive)ShrinkWrap.create(JavaArchive.class, (String)CDI_CONTEXT_B);
        archive.addAsManifestResource((Asset)EmptyAsset.INSTANCE, "beans.xml");
        archive.addPackage(InjectedContextBean.class.getPackage());
        return archive;
    }

    private class FakeContextTracker
    extends CamelContextTracker {
        private List<CamelContext> camelContextList = new ArrayList<CamelContext>();

        private FakeContextTracker() {
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void contextCreated(CamelContext camelctx) {
            List<CamelContext> list = this.camelContextList;
            synchronized (list) {
                this.camelContextList.add(camelctx);
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        int getContextCount() {
            List<CamelContext> list = this.camelContextList;
            synchronized (list) {
                return this.camelContextList.size();
            }
        }
    }
}

