/*
 * Decompiled with CFR 0.152.
 */
package org.wildfly.camel.test.jpa;

import javax.annotation.Resource;
import javax.persistence.EntityManagerFactory;
import javax.transaction.UserTransaction;
import org.apache.camel.Expression;
import org.apache.camel.ProducerTemplate;
import org.apache.camel.RoutesBuilder;
import org.apache.camel.builder.RouteBuilder;
import org.apache.camel.component.mock.MockEndpoint;
import org.apache.camel.impl.DefaultCamelContext;
import org.apache.camel.processor.idempotent.jpa.JpaMessageIdRepository;
import org.apache.camel.spi.IdempotentRepository;
import org.jboss.arquillian.container.test.api.Deployment;
import org.jboss.arquillian.junit.Arquillian;
import org.jboss.shrinkwrap.api.ShrinkWrap;
import org.jboss.shrinkwrap.api.asset.Asset;
import org.jboss.shrinkwrap.api.asset.EmptyAsset;
import org.jboss.shrinkwrap.api.spec.JavaArchive;
import org.junit.Test;
import org.junit.runner.RunWith;
import org.springframework.transaction.PlatformTransactionManager;
import org.springframework.transaction.jta.JtaTransactionManager;
import org.springframework.transaction.support.TransactionTemplate;
import org.wildfly.extension.camel.CamelAware;

@CamelAware
@RunWith(value=Arquillian.class)
public class JPAIdempotentConsumerIntegrationTest {
    @Resource(mappedName="java:jboss/IdempotentTestManagerFactory")
    private EntityManagerFactory entityManagerFactory;
    @Resource(mappedName="java:jboss/UserTransaction")
    private UserTransaction userTransaction;

    @Deployment
    public static JavaArchive deployment() {
        JavaArchive archive = (JavaArchive)ShrinkWrap.create(JavaArchive.class, (String)"jpa-idempotent-tests.jar");
        archive.addAsResource("jpa/persistence-idempotent.xml", "META-INF/persistence.xml");
        archive.addAsManifestResource((Asset)EmptyAsset.INSTANCE, "beans.xml");
        return archive;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    public void testJPAIdempotentConsumer() throws Exception {
        TransactionTemplate transactionTemplate = new TransactionTemplate();
        transactionTemplate.setTransactionManager((PlatformTransactionManager)new JtaTransactionManager(this.userTransaction));
        transactionTemplate.setPropagationBehavior(0);
        final JpaMessageIdRepository messageIdRepository = new JpaMessageIdRepository(this.entityManagerFactory, transactionTemplate, "myProcessorName");
        DefaultCamelContext camelctx = new DefaultCamelContext();
        camelctx.addRoutes((RoutesBuilder)new RouteBuilder(){

            public void configure() throws Exception {
                this.from("direct:start").idempotentConsumer((Expression)this.simple("${header.messageId}"), (IdempotentRepository)messageIdRepository).to("mock:result");
            }
        });
        camelctx.start();
        try {
            MockEndpoint mockEndpoint = (MockEndpoint)camelctx.getEndpoint("mock:result", MockEndpoint.class);
            mockEndpoint.expectedMessageCount(1);
            ProducerTemplate template = camelctx.createProducerTemplate();
            for (int i = 0; i < 5; ++i) {
                template.requestBodyAndHeader("direct:start", null, "messageId", (Object)"12345");
            }
            mockEndpoint.assertIsSatisfied();
        }
        finally {
            camelctx.stop();
        }
    }
}

