/*
 * Decompiled with CFR 0.152.
 */
package org.wildfly.camel.test.jpa.subA;

import javax.annotation.Resource;
import javax.ejb.SessionContext;
import javax.ejb.Stateless;
import javax.ejb.TransactionAttribute;
import javax.ejb.TransactionAttributeType;
import javax.persistence.EntityManager;
import javax.persistence.PersistenceContext;
import org.apache.camel.ProducerTemplate;
import org.apache.camel.RoutesBuilder;
import org.apache.camel.builder.RouteBuilder;
import org.apache.camel.impl.DefaultCamelContext;
import org.wildfly.camel.test.jpa.subA.Account;

@Stateless
public class Accounting {
    @PersistenceContext
    EntityManager em;
    @Resource
    SessionContext context;

    @TransactionAttribute(value=TransactionAttributeType.REQUIRED)
    public void transfer(int amount) {
        Account accountA = (Account)this.em.getReference(Account.class, (Object)1);
        Account accountB = (Account)this.em.getReference(Account.class, (Object)2);
        accountA.setBalance(accountA.getBalance() - amount);
        this.em.createQuery("update Account set balance = " + accountA.getBalance() + " where id = 3").executeUpdate();
        if (accountA.getBalance() < 0) {
            this.context.setRollbackOnly();
            return;
        }
        accountB.setBalance(accountB.getBalance() + amount);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @TransactionAttribute(value=TransactionAttributeType.REQUIRED)
    public void transferCamel(int amount) throws Exception {
        Account accountA = (Account)this.em.getReference(Account.class, (Object)1);
        Account accountB = (Account)this.em.getReference(Account.class, (Object)2);
        accountA.setBalance(accountA.getBalance() - amount);
        DefaultCamelContext camelctx = new DefaultCamelContext();
        camelctx.addRoutes((RoutesBuilder)new RouteBuilder(){

            public void configure() throws Exception {
                this.from("direct:start").wireTap("log:org.wildfly.camel.test.jpa?level=WARN").to("sql:update Account set balance = :#${body} where id = 3?dataSource=java:jboss/datasources/ExampleDS");
            }
        });
        camelctx.start();
        try {
            ProducerTemplate producer = camelctx.createProducerTemplate();
            producer.requestBody("direct:start", (Object)accountA.getBalance());
        }
        finally {
            camelctx.stop();
        }
        if (accountA.getBalance() < 0) {
            this.context.setRollbackOnly();
            return;
        }
        accountB.setBalance(accountB.getBalance() + amount);
    }
}

