/*
 * Decompiled with CFR 0.152.
 */
package org.wildfly.camel.test.jpa.subA;

import java.util.List;
import java.util.Map;
import javax.ejb.Startup;
import javax.inject.Inject;
import javax.persistence.EntityManager;
import javax.persistence.PersistenceContext;
import org.apache.camel.Component;
import org.apache.camel.Exchange;
import org.apache.camel.Expression;
import org.apache.camel.Predicate;
import org.apache.camel.Processor;
import org.apache.camel.builder.RouteBuilder;
import org.apache.camel.component.jpa.JpaComponent;
import org.apache.camel.model.ChoiceDefinition;
import org.apache.camel.model.OnExceptionDefinition;
import org.apache.camel.model.RouteDefinition;
import org.apache.camel.model.TransactedDefinition;
import org.springframework.transaction.PlatformTransactionManager;
import org.springframework.transaction.jta.JtaTransactionManager;
import org.wildfly.camel.test.jpa.subA.Account;
import org.wildfly.extension.camel.CamelAware;

@Startup
@CamelAware
public class JpaRouteBuilder
extends RouteBuilder {
    @PersistenceContext
    EntityManager em;
    @Inject
    JtaTransactionManager transactionManager;

    public void configure() throws Exception {
        JpaComponent jpaComponent = new JpaComponent();
        jpaComponent.setEntityManagerFactory(this.em.getEntityManagerFactory());
        jpaComponent.setTransactionManager((PlatformTransactionManager)this.transactionManager);
        this.getContext().addComponent("jpa", (Component)jpaComponent);
        ((OnExceptionDefinition)((OnExceptionDefinition)this.onException(IllegalArgumentException.class).maximumRedeliveries(1).handled(true).convertBodyTo(String.class)).to("file:{{jboss.server.data.dir}}/deadletter?fileName=deadLetters.xml")).markRollbackOnly();
        ((ChoiceDefinition)((ChoiceDefinition)((TransactedDefinition)((TransactedDefinition)((TransactedDefinition)this.from("direct:start").transacted().setHeader("targetAccountId", (Expression)this.simple("${body[targetAccountId]}"))).setHeader("amount", (Expression)this.simple("${body[amount]}"))).to("sql:update account set balance = balance - :#amount where id = :#sourceAccountId?dataSource=wildFlyExampleDS")).choice().when((Predicate)this.simple("${header.amount} > 500")).log("Amount is too large! Rolling back transaction")).throwException((Exception)new IllegalArgumentException("Amount too large"))).otherwise().to("direct:txsmall");
        ((RouteDefinition)((RouteDefinition)this.from("direct:txsmall").to("sql:select balance from account where id = :#targetAccountId?dataSource=wildFlyExampleDS")).process(new Processor(){

            public void process(Exchange exchange) throws Exception {
                List result = (List)exchange.getIn().getBody();
                int id = (Integer)exchange.getIn().getHeader("targetAccountId", Integer.class);
                int amount = (Integer)exchange.getIn().getHeader("amount", Integer.class);
                int balance = (Integer)((Map)result.get(0)).get("BALANCE");
                Account account = (Account)JpaRouteBuilder.this.em.find(Account.class, (Object)id);
                account.setBalance(balance + amount);
                exchange.getOut().setBody((Object)account);
            }
        })).to("jpa:org.wildfly.camel.test.jpa.subA.Account");
    }
}

