/*
 * Decompiled with CFR 0.152.
 */
package org.wildfly.camel.test.restlet;

import java.net.MalformedURLException;
import org.apache.camel.Expression;
import org.apache.camel.ProducerTemplate;
import org.apache.camel.RoutesBuilder;
import org.apache.camel.builder.RouteBuilder;
import org.apache.camel.impl.DefaultCamelContext;
import org.apache.camel.model.RouteDefinition;
import org.jboss.arquillian.container.test.api.Deployer;
import org.jboss.arquillian.container.test.api.Deployment;
import org.jboss.arquillian.junit.Arquillian;
import org.jboss.arquillian.test.api.ArquillianResource;
import org.jboss.shrinkwrap.api.Archive;
import org.jboss.shrinkwrap.api.ShrinkWrap;
import org.jboss.shrinkwrap.api.spec.JavaArchive;
import org.jboss.shrinkwrap.api.spec.WebArchive;
import org.junit.Assert;
import org.junit.Test;
import org.junit.runner.RunWith;
import org.wildfly.camel.test.common.types.GreetingService;
import org.wildfly.camel.test.common.types.GreetingServiceImpl;
import org.wildfly.camel.test.common.types.RestApplication;
import org.wildfly.extension.camel.CamelAware;

@CamelAware
@RunWith(value=Arquillian.class)
public class RestletProducerIntegrationTest {
    static final String SIMPLE_WAR = "simple-rs-endpoint.war";
    @ArquillianResource
    Deployer deployer;

    @Deployment
    public static JavaArchive deployment() {
        JavaArchive archive = (JavaArchive)ShrinkWrap.create(JavaArchive.class, (String)"restlet-tests");
        archive.addClasses(new Class[]{GreetingService.class});
        return archive;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    public void testRestletProducer() throws Exception {
        this.deployer.deploy(SIMPLE_WAR);
        try {
            DefaultCamelContext camelctx = new DefaultCamelContext();
            camelctx.addRoutes((RoutesBuilder)new RouteBuilder(){

                public void configure() throws Exception {
                    ((RouteDefinition)this.from("direct:start").setHeader("CamelHttpMethod", (Expression)this.constant("GET"))).to("restlet://" + RestletProducerIntegrationTest.this.getEndpointAddress("simple-rs-endpoint", "hello") + "?resourceClasses=" + GreetingService.class.getName());
                }
            });
            camelctx.start();
            try {
                ProducerTemplate producer = camelctx.createProducerTemplate();
                String result = (String)producer.requestBodyAndHeader("direct:start", (Object)"mybody", "name", (Object)"Kermit", String.class);
                Assert.assertEquals((Object)"Hello Kermit", (Object)result);
            }
            finally {
                camelctx.stop();
            }
        }
        finally {
            this.deployer.undeploy(SIMPLE_WAR);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    public void testRestletProducerPost() throws Exception {
        this.deployer.deploy(SIMPLE_WAR);
        try {
            DefaultCamelContext camelctx = new DefaultCamelContext();
            camelctx.addRoutes((RoutesBuilder)new RouteBuilder(){

                public void configure() throws Exception {
                    this.from("direct:start").to("restlet://" + RestletProducerIntegrationTest.this.getEndpointAddress("simple-rs-endpoint", "goodbye") + "?restletMethod=POST&resourceClasses=" + GreetingService.class.getName());
                }
            });
            camelctx.start();
            try {
                ProducerTemplate producer = camelctx.createProducerTemplate();
                String result = (String)producer.requestBodyAndHeader("direct:start", (Object)"mybody", "name", (Object)"Kermit", String.class);
                Assert.assertEquals((Object)"Goodbye Kermit", (Object)result);
            }
            finally {
                camelctx.stop();
            }
        }
        finally {
            this.deployer.undeploy(SIMPLE_WAR);
        }
    }

    private String getEndpointAddress(String contextPath, String action) throws MalformedURLException {
        return String.format("http://localhost:8080/%s/rest/greet/%s/Kermit", contextPath, action);
    }

    @Deployment(name="simple-rs-endpoint.war", managed=false, testable=false)
    public static Archive<?> getSimpleWar() {
        WebArchive archive = (WebArchive)ShrinkWrap.create(WebArchive.class, (String)SIMPLE_WAR);
        archive.addClasses(new Class[]{RestApplication.class, GreetingServiceImpl.class, GreetingService.class});
        return archive;
    }
}

