/*
 * Decompiled with CFR 0.152.
 */
package org.wildfly.camel.test.cdi;

import java.util.ArrayList;
import java.util.List;
import java.util.concurrent.TimeUnit;
import org.apache.camel.CamelContext;
import org.apache.camel.ServiceStatus;
import org.apache.camel.component.mock.MockEndpoint;
import org.apache.camel.spi.CamelContextTracker;
import org.jboss.arquillian.container.test.api.Deployer;
import org.jboss.arquillian.container.test.api.Deployment;
import org.jboss.arquillian.junit.Arquillian;
import org.jboss.arquillian.test.api.ArquillianResource;
import org.jboss.shrinkwrap.api.ShrinkWrap;
import org.jboss.shrinkwrap.api.asset.Asset;
import org.jboss.shrinkwrap.api.asset.EmptyAsset;
import org.jboss.shrinkwrap.api.spec.JavaArchive;
import org.junit.Assert;
import org.junit.Test;
import org.junit.runner.RunWith;
import org.wildfly.camel.test.cdi.subA.RouteBuilderE;
import org.wildfly.camel.test.cdi.subA.RouteBuilderF;
import org.wildfly.extension.camel.CamelAware;
import org.wildfly.extension.camel.CamelContextRegistry;

@CamelAware
@RunWith(value=Arquillian.class)
public class CDIContextCreationTest {
    private static final String CDI_CONTEXT_A = "cdi-context-a.jar";
    private static final String CDI_CONTEXT_B = "cdi-context-b.jar";
    private static final String CDI_CONTEXT_C = "cdi-context-c.jar";
    @ArquillianResource
    private Deployer deployer;
    @ArquillianResource
    private CamelContextRegistry contextRegistry;

    @Deployment
    public static JavaArchive createDeployment() {
        JavaArchive archive = (JavaArchive)ShrinkWrap.create(JavaArchive.class);
        archive.addClasses(new Class[]{RouteBuilderF.class});
        return archive;
    }

    @Test
    public void testCDIContextCreation() throws InterruptedException {
        try (FakeContextTracker tracker = new FakeContextTracker();){
            tracker.open();
            Assert.assertEquals((long)0L, (long)tracker.getContextCount());
            Assert.assertEquals((long)0L, (long)this.contextRegistry.getCamelContexts().size());
            this.deployer.deploy(CDI_CONTEXT_A);
            Assert.assertEquals((long)1L, (long)tracker.getContextCount());
            Assert.assertEquals((long)1L, (long)this.contextRegistry.getCamelContexts().size());
            this.deployer.deploy(CDI_CONTEXT_B);
            Assert.assertEquals((long)2L, (long)tracker.getContextCount());
            Assert.assertEquals((long)2L, (long)this.contextRegistry.getCamelContexts().size());
            this.deployer.undeploy(CDI_CONTEXT_A);
            this.deployer.undeploy(CDI_CONTEXT_B);
            Assert.assertEquals((long)0L, (long)this.contextRegistry.getCamelContexts().size());
        }
    }

    @Test
    public void testManualComponentConfig() throws InterruptedException {
        this.deployer.deploy(CDI_CONTEXT_C);
        try {
            Assert.assertEquals((long)1L, (long)this.contextRegistry.getCamelContexts().size());
            CamelContext camelctx = this.contextRegistry.getCamelContext("contextF");
            Assert.assertNotNull((String)"Context not null", (Object)camelctx);
            Assert.assertEquals((Object)ServiceStatus.Started, (Object)camelctx.getStatus());
            MockEndpoint mock = (MockEndpoint)camelctx.getEndpoint("mock:result?expectedCount=3", MockEndpoint.class);
            Assert.assertTrue((String)"All messages received", (boolean)mock.await(500L, TimeUnit.MILLISECONDS));
            Assert.assertEquals((long)3L, (long)mock.getExpectedCount());
        }
        finally {
            this.deployer.undeploy(CDI_CONTEXT_C);
        }
    }

    @Deployment(name="cdi-context-a.jar", managed=false, testable=false)
    public static JavaArchive createTestJarA() {
        JavaArchive archive = (JavaArchive)ShrinkWrap.create(JavaArchive.class, (String)CDI_CONTEXT_A);
        archive.addAsManifestResource((Asset)EmptyAsset.INSTANCE, "beans.xml");
        archive.addClasses(new Class[]{RouteBuilderE.class});
        return archive;
    }

    @Deployment(name="cdi-context-b.jar", managed=false, testable=false)
    public static JavaArchive createTestJarB() {
        JavaArchive archive = (JavaArchive)ShrinkWrap.create(JavaArchive.class, (String)CDI_CONTEXT_B);
        archive.addAsManifestResource((Asset)EmptyAsset.INSTANCE, "beans.xml");
        archive.addClasses(new Class[]{RouteBuilderE.class});
        return archive;
    }

    @Deployment(name="cdi-context-c.jar", managed=false, testable=false)
    public static JavaArchive createTestJarC() {
        JavaArchive archive = (JavaArchive)ShrinkWrap.create(JavaArchive.class, (String)CDI_CONTEXT_C);
        archive.addAsManifestResource((Asset)EmptyAsset.INSTANCE, "beans.xml");
        archive.addClasses(new Class[]{RouteBuilderF.class});
        return archive;
    }

    private class FakeContextTracker
    extends CamelContextTracker {
        private List<CamelContext> camelContextList = new ArrayList<CamelContext>();

        private FakeContextTracker() {
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void contextCreated(CamelContext camelctx) {
            List<CamelContext> list = this.camelContextList;
            synchronized (list) {
                this.camelContextList.add(camelctx);
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        int getContextCount() {
            List<CamelContext> list = this.camelContextList;
            synchronized (list) {
                return this.camelContextList.size();
            }
        }
    }
}

