/*
 * Decompiled with CFR 0.152.
 */
package org.wildfly.camel.test.cdi;

import javax.inject.Inject;
import org.apache.camel.CamelContext;
import org.apache.camel.ProducerTemplate;
import org.apache.camel.ServiceStatus;
import org.apache.camel.cdi.ContextName;
import org.apache.camel.cdi.Uri;
import org.jboss.arquillian.container.test.api.Deployment;
import org.jboss.arquillian.junit.Arquillian;
import org.jboss.arquillian.test.api.ArquillianResource;
import org.jboss.shrinkwrap.api.ShrinkWrap;
import org.jboss.shrinkwrap.api.asset.Asset;
import org.jboss.shrinkwrap.api.asset.EmptyAsset;
import org.jboss.shrinkwrap.api.spec.JavaArchive;
import org.junit.Assert;
import org.junit.Test;
import org.junit.runner.RunWith;
import org.wildfly.camel.test.cdi.subA.RouteBuilderG;
import org.wildfly.extension.camel.CamelContextRegistry;

@RunWith(value=Arquillian.class)
public class CDISpringContextInjectionTest {
    @ArquillianResource
    private CamelContextRegistry contextRegistry;
    @Inject
    @ContextName(value="contextG")
    @Uri(value="direct:start")
    ProducerTemplate producerG;

    @Deployment
    public static JavaArchive createDeployment() {
        JavaArchive archive = (JavaArchive)ShrinkWrap.create(JavaArchive.class);
        archive.addAsManifestResource((Asset)EmptyAsset.INSTANCE, "beans.xml");
        archive.addAsResource("cdi/camel-context.xml");
        archive.addClasses(new Class[]{RouteBuilderG.class});
        return archive;
    }

    @Test
    public void testCDIContextCreation() throws InterruptedException {
        this.assertCamelContext("contextG");
        String result = (String)this.producerG.requestBody("direct:start", (Object)"Kermit", String.class);
        Assert.assertEquals((Object)"Hello Kermit", (Object)result);
    }

    private CamelContext assertCamelContext(String contextName) {
        CamelContext camelctx = this.contextRegistry.getCamelContext(contextName);
        Assert.assertEquals((Object)ServiceStatus.Started, (Object)camelctx.getStatus());
        return camelctx;
    }
}

