/*
 * Decompiled with CFR 0.152.
 */
package org.wildfly.camel.test.mail;

import java.io.File;
import java.util.HashMap;
import org.apache.camel.ProducerTemplate;
import org.apache.camel.RoutesBuilder;
import org.apache.camel.builder.RouteBuilder;
import org.apache.camel.component.mock.MockEndpoint;
import org.apache.camel.impl.DefaultCamelContext;
import org.jboss.arquillian.container.test.api.Deployer;
import org.jboss.arquillian.container.test.api.Deployment;
import org.jboss.arquillian.junit.Arquillian;
import org.jboss.arquillian.test.api.ArquillianResource;
import org.jboss.as.arquillian.api.ServerSetup;
import org.jboss.as.arquillian.api.ServerSetupTask;
import org.jboss.as.arquillian.container.ManagementClient;
import org.jboss.dmr.ModelNode;
import org.jboss.shrinkwrap.api.ShrinkWrap;
import org.jboss.shrinkwrap.api.spec.JavaArchive;
import org.jboss.shrinkwrap.api.spec.WebArchive;
import org.jboss.shrinkwrap.resolver.api.maven.Maven;
import org.jboss.shrinkwrap.resolver.api.maven.MavenFormatStage;
import org.jboss.shrinkwrap.resolver.api.maven.MavenStrategyStage;
import org.junit.Test;
import org.junit.runner.RunWith;
import org.wildfly.camel.test.common.utils.DMRUtils;
import org.wildfly.extension.camel.CamelAware;

@CamelAware
@ServerSetup(value={MailSessionSetupTask.class})
@RunWith(value=Arquillian.class)
public class MailIntegrationTest {
    private static final String GREENMAIL_WAR = "greenmail.war";
    @ArquillianResource
    Deployer deployer;

    @Deployment
    public static JavaArchive createDeployment() {
        return (JavaArchive)ShrinkWrap.create(JavaArchive.class, (String)"camel-mail-tests.jar");
    }

    @Deployment(managed=false, testable=false, name="greenmail.war")
    public static WebArchive createGreenmailDeployment() {
        File mailDependencies = ((MavenFormatStage)((MavenStrategyStage)Maven.configureResolverViaPlugin().resolve("com.icegreen:greenmail-webapp:war:1.4.0")).withoutTransitivity()).asSingleFile();
        return (WebArchive)ShrinkWrap.createFromZipFile(WebArchive.class, (File)mailDependencies);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    public void testMailEndpoint() throws Exception {
        DefaultCamelContext camelctx = new DefaultCamelContext();
        camelctx.addRoutes((RoutesBuilder)new RouteBuilder(){

            public void configure() throws Exception {
                this.from("direct:start").to("smtp://localhost:10025?session=#java:jboss/mail/greenmail");
                this.from("pop3://user2@localhost:10110?consumer.delay=1000&session=#java:jboss/mail/greenmail&delete=true").to("mock:result");
            }
        });
        try {
            this.deployer.deploy(GREENMAIL_WAR);
            camelctx.start();
            MockEndpoint mockEndpoint = (MockEndpoint)camelctx.getEndpoint("mock:result", MockEndpoint.class);
            mockEndpoint.setExpectedMessageCount(1);
            HashMap<String, String> mailHeaders = new HashMap<String, String>();
            mailHeaders.put("from", "user1@localhost");
            mailHeaders.put("to", "user2@localhost");
            mailHeaders.put("message", "Hello Kermit");
            ProducerTemplate template = camelctx.createProducerTemplate();
            template.requestBodyAndHeaders("direct:start", null, mailHeaders);
            mockEndpoint.assertIsSatisfied(5000L);
        }
        finally {
            camelctx.stop();
            this.deployer.undeploy(GREENMAIL_WAR);
        }
    }

    static class MailSessionSetupTask
    implements ServerSetupTask {
        MailSessionSetupTask() {
        }

        public void setup(ManagementClient managementClient, String s) throws Exception {
            ModelNode batchNode = DMRUtils.batchNode().addStep("socket-binding-group=standard-sockets/remote-destination-outbound-socket-binding=mail-greenmail-smtp", "add(host=localhost, port=10025)").addStep("socket-binding-group=standard-sockets/remote-destination-outbound-socket-binding=mail-greenmail-pop3", "add(host=localhost, port=10110)").addStep("subsystem=mail/mail-session=greenmail", "add(jndi-name=java:jboss/mail/greenmail)").addStep("subsystem=mail/mail-session=greenmail/server=smtp", "add(outbound-socket-binding-ref=mail-greenmail-smtp, username=user1, password=password)").addStep("subsystem=mail/mail-session=greenmail/server=pop3", "add(outbound-socket-binding-ref=mail-greenmail-pop3, username=user2, password=password2)").build();
            managementClient.getControllerClient().execute(batchNode);
        }

        public void tearDown(ManagementClient managementClient, String s) throws Exception {
            ModelNode batchNode = DMRUtils.batchNode().addStep("socket-binding-group=standard-sockets/remote-destination-outbound-socket-binding=mail-greenmail-smtp", "remove").addStep("socket-binding-group=standard-sockets/remote-destination-outbound-socket-binding=mail-greenmail-pop3", "remove").addStep("subsystem=mail/mail-session=greenmail", "remove").addStep("subsystem=mail/mail-session=greenmail/server=smtp", "remove").addStep("subsystem=mail/mail-session=greenmail/server=pop3", "remove").build();
            managementClient.getControllerClient().execute(batchNode);
        }
    }
}

