/*
 * Decompiled with CFR 0.152.
 */
package org.wildfly.camel.test.mongodb;

import com.mongodb.BasicDBObject;
import com.mongodb.DBObject;
import com.mongodb.MongoClient;
import com.mongodb.client.MongoCollection;
import com.mongodb.client.MongoDatabase;
import com.mongodb.util.JSON;
import java.io.Closeable;
import java.util.Formatter;
import java.util.List;
import javax.naming.InitialContext;
import org.apache.camel.ProducerTemplate;
import org.apache.camel.RoutesBuilder;
import org.apache.camel.builder.RouteBuilder;
import org.apache.camel.impl.DefaultCamelContext;
import org.apache.camel.util.IOHelper;
import org.jboss.arquillian.container.test.api.Deployment;
import org.jboss.arquillian.junit.Arquillian;
import org.jboss.shrinkwrap.api.ShrinkWrap;
import org.jboss.shrinkwrap.api.spec.JavaArchive;
import org.junit.After;
import org.junit.AfterClass;
import org.junit.Assert;
import org.junit.Before;
import org.junit.BeforeClass;
import org.junit.Test;
import org.junit.runner.RunWith;
import org.wildfly.camel.test.mongodb.EmbeddedMongoServer;
import org.wildfly.extension.camel.CamelAware;

@CamelAware
@RunWith(value=Arquillian.class)
public class MongoDBIntegrationTest {
    private static final int PORT = 27017;
    private static EmbeddedMongoServer mongoServer;
    private MongoCollection<BasicDBObject> testCollection;
    private MongoCollection<BasicDBObject> dynamicCollection;

    @Deployment
    public static JavaArchive createDeployment() {
        return (JavaArchive)((JavaArchive)ShrinkWrap.create(JavaArchive.class, (String)"camel-mongodb-tests")).addClass(EmbeddedMongoServer.class);
    }

    @BeforeClass
    public static void beforeClass() throws Exception {
        if (mongoServer == null) {
            mongoServer = new EmbeddedMongoServer(27017);
        }
        mongoServer.start();
    }

    @AfterClass
    public static void afterClass() {
        mongoServer.stop();
    }

    @Before
    public void setUp() throws Exception {
        MongoClient client = new MongoClient("localhost", 27017);
        MongoDatabase db = client.getDatabase("test");
        InitialContext context = new InitialContext();
        context.bind("mongoConnection", (Object)client);
        String testCollectionName = "camelTest";
        this.testCollection = db.getCollection(testCollectionName, BasicDBObject.class);
        this.testCollection.drop();
        this.testCollection = db.getCollection(testCollectionName, BasicDBObject.class);
        String dynamicCollectionName = testCollectionName.concat("Dynamic");
        this.dynamicCollection = db.getCollection(dynamicCollectionName, BasicDBObject.class);
        this.dynamicCollection.drop();
        this.dynamicCollection = db.getCollection(dynamicCollectionName, BasicDBObject.class);
        this.setupTestData();
    }

    @After
    public void tearDown() throws Exception {
        InitialContext context = new InitialContext();
        context.unbind("mongoConnection");
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    public void testMongoFindAll() throws Exception {
        DefaultCamelContext camelctx = new DefaultCamelContext();
        camelctx.addRoutes((RoutesBuilder)new RouteBuilder(){

            public void configure() throws Exception {
                this.from("direct:start").to("mongodb:mongoConnection?database=test&collection=camelTest&operation=findAll&dynamicity=true");
            }
        });
        camelctx.start();
        try {
            ProducerTemplate template = camelctx.createProducerTemplate();
            List result = (List)template.requestBody("direct:start", null, List.class);
            Assert.assertEquals((long)1000L, (long)result.size());
            for (DBObject dbObject : result) {
                Assert.assertNotNull((Object)dbObject.get("_id"));
                Assert.assertNotNull((Object)dbObject.get("scientist"));
                Assert.assertNotNull((Object)dbObject.get("fixedField"));
            }
        }
        finally {
            this.testCollection.drop();
            this.dynamicCollection.drop();
            camelctx.stop();
        }
    }

    private void setupTestData() {
        String[] scientists = new String[]{"Einstein", "Darwin", "Copernicus", "Pasteur", "Curie", "Faraday", "Newton", "Bohr", "Galilei", "Maxwell"};
        for (int i = 1; i <= 1000; ++i) {
            int index = i % scientists.length;
            Formatter f = new Formatter();
            String doc = f.format("{\"_id\":\"%d\", \"scientist\":\"%s\", \"fixedField\": \"fixedValue\"}", i, scientists[index]).toString();
            IOHelper.close((Closeable)f);
            this.testCollection.insertOne((Object)((BasicDBObject)JSON.parse((String)doc)));
        }
    }
}

