/*
 * Decompiled with CFR 0.152.
 */
package org.wildfly.camel.test.olingo2.subA;

import java.util.ArrayList;
import java.util.Calendar;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.TimeZone;

public class DataStore {
    public Map<String, Object> getCar(int id) {
        Map<String, Object> data = null;
        Calendar updated = Calendar.getInstance(TimeZone.getTimeZone("GMT"));
        switch (id) {
            case 1: {
                updated.set(2012, 11, 11, 11, 11, 11);
                data = this.createCar(1, "F1 W03", 1, 189189.43, "EUR", "2012", updated, "file://imagePath/w03");
                break;
            }
            case 2: {
                updated.set(2013, 11, 11, 11, 11, 11);
                data = this.createCar(2, "F1 W04", 1, 199999.99, "EUR", "2013", updated, "file://imagePath/w04");
                break;
            }
            case 3: {
                updated.set(2012, 12, 12, 12, 12, 12);
                data = this.createCar(3, "F2012", 2, 137285.33, "EUR", "2012", updated, "http://pathToImage/f2012");
                break;
            }
            case 4: {
                updated.set(2013, 12, 12, 12, 12, 12);
                data = this.createCar(4, "F2013", 2, 145285.0, "EUR", "2013", updated, "http://pathToImage/f2013");
                break;
            }
            case 5: {
                updated.set(2011, 11, 11, 11, 11, 11);
                data = this.createCar(5, "F1 W02", 1, 167189.0, "EUR", "2011", updated, "file://imagePath/wXX");
                break;
            }
        }
        return data;
    }

    private Map<String, Object> createCar(int carId, String model, int manufacturerId, double price, String currency, String modelYear, Calendar updated, String imagePath) {
        HashMap<String, Object> data = new HashMap<String, Object>();
        data.put("Id", carId);
        data.put("Model", model);
        data.put("ManufacturerId", manufacturerId);
        data.put("Price", price);
        data.put("Currency", currency);
        data.put("ModelYear", modelYear);
        data.put("Updated", updated);
        data.put("ImagePath", imagePath);
        return data;
    }

    public Map<String, Object> getManufacturer(int id) {
        Map<String, Object> data = null;
        Calendar date = Calendar.getInstance(TimeZone.getTimeZone("GMT"));
        switch (id) {
            case 1: {
                Map<String, Object> addressStar = this.createAddress("Star Street 137", "Stuttgart", "70173", "Germany");
                date.set(1954, 7, 4);
                data = this.createManufacturer(1, "Star Powered Racing", addressStar, date);
                break;
            }
            case 2: {
                Map<String, Object> addressHorse = this.createAddress("Horse Street 1", "Maranello", "41053", "Italy");
                date.set(1929, 11, 16);
                data = this.createManufacturer(2, "Horse Powered Racing", addressHorse, date);
                break;
            }
        }
        return data;
    }

    private Map<String, Object> createManufacturer(int id, String name, Map<String, Object> address, Calendar updated) {
        HashMap<String, Object> data = new HashMap<String, Object>();
        data.put("Id", id);
        data.put("Name", name);
        data.put("Address", address);
        data.put("Updated", updated);
        return data;
    }

    private Map<String, Object> createAddress(String street, String city, String zipCode, String country) {
        HashMap<String, Object> address = new HashMap<String, Object>();
        address.put("Street", street);
        address.put("City", city);
        address.put("ZipCode", zipCode);
        address.put("Country", country);
        return address;
    }

    public List<Map<String, Object>> getCars() {
        ArrayList<Map<String, Object>> cars = new ArrayList<Map<String, Object>>();
        cars.add(this.getCar(1));
        cars.add(this.getCar(2));
        cars.add(this.getCar(3));
        cars.add(this.getCar(4));
        cars.add(this.getCar(5));
        return cars;
    }

    public List<Map<String, Object>> getManufacturers() {
        ArrayList<Map<String, Object>> manufacturers = new ArrayList<Map<String, Object>>();
        manufacturers.add(this.getManufacturer(1));
        manufacturers.add(this.getManufacturer(2));
        return manufacturers;
    }

    public List<Map<String, Object>> getCarsFor(int manufacturerId) {
        List<Map<String, Object>> cars = this.getCars();
        ArrayList<Map<String, Object>> carsForManufacturer = new ArrayList<Map<String, Object>>();
        for (Map<String, Object> car : cars) {
            if (!Integer.valueOf(manufacturerId).equals(car.get("ManufacturerId"))) continue;
            carsForManufacturer.add(car);
        }
        return carsForManufacturer;
    }

    public Map<String, Object> getManufacturerFor(int carId) {
        Object manufacturerId;
        Map<String, Object> car = this.getCar(carId);
        if (car != null && (manufacturerId = car.get("ManufacturerId")) != null) {
            return this.getManufacturer((Integer)manufacturerId);
        }
        return null;
    }
}

