/*
 * Decompiled with CFR 0.152.
 */
package org.wildfly.camel.test.olingo2.subA;

import java.net.URI;
import java.util.ArrayList;
import java.util.Map;
import org.apache.olingo.odata2.api.edm.EdmEntitySet;
import org.apache.olingo.odata2.api.edm.EdmLiteralKind;
import org.apache.olingo.odata2.api.edm.EdmProperty;
import org.apache.olingo.odata2.api.edm.EdmSimpleType;
import org.apache.olingo.odata2.api.ep.EntityProvider;
import org.apache.olingo.odata2.api.ep.EntityProviderWriteProperties;
import org.apache.olingo.odata2.api.exception.ODataException;
import org.apache.olingo.odata2.api.exception.ODataNotFoundException;
import org.apache.olingo.odata2.api.exception.ODataNotImplementedException;
import org.apache.olingo.odata2.api.processor.ODataResponse;
import org.apache.olingo.odata2.api.processor.ODataSingleProcessor;
import org.apache.olingo.odata2.api.uri.KeyPredicate;
import org.apache.olingo.odata2.api.uri.info.GetEntitySetUriInfo;
import org.apache.olingo.odata2.api.uri.info.GetEntityUriInfo;
import org.wildfly.camel.test.olingo2.subA.DataStore;

public class MyODataSingleProcessor
extends ODataSingleProcessor {
    private final DataStore dataStore = new DataStore();

    public ODataResponse readEntitySet(GetEntitySetUriInfo uriInfo, String contentType) throws ODataException {
        if (uriInfo.getNavigationSegments().size() == 0) {
            EdmEntitySet entitySet = uriInfo.getStartEntitySet();
            if ("Cars".equals(entitySet.getName())) {
                return EntityProvider.writeFeed((String)contentType, (EdmEntitySet)entitySet, this.dataStore.getCars(), (EntityProviderWriteProperties)EntityProviderWriteProperties.serviceRoot((URI)this.getContext().getPathInfo().getServiceRoot()).build());
            }
            if ("Manufacturers".equals(entitySet.getName())) {
                return EntityProvider.writeFeed((String)contentType, (EdmEntitySet)entitySet, this.dataStore.getManufacturers(), (EntityProviderWriteProperties)EntityProviderWriteProperties.serviceRoot((URI)this.getContext().getPathInfo().getServiceRoot()).build());
            }
            throw new ODataNotFoundException(ODataNotFoundException.ENTITY);
        }
        if (uriInfo.getNavigationSegments().size() == 1) {
            EdmEntitySet entitySet = uriInfo.getTargetEntitySet();
            if ("Cars".equals(entitySet.getName())) {
                int manufacturerKey = this.getKeyValue((KeyPredicate)uriInfo.getKeyPredicates().get(0));
                ArrayList<Map<String, Object>> cars = new ArrayList<Map<String, Object>>();
                cars.addAll(this.dataStore.getCarsFor(manufacturerKey));
                return EntityProvider.writeFeed((String)contentType, (EdmEntitySet)entitySet, cars, (EntityProviderWriteProperties)EntityProviderWriteProperties.serviceRoot((URI)this.getContext().getPathInfo().getServiceRoot()).build());
            }
            throw new ODataNotFoundException(ODataNotFoundException.ENTITY);
        }
        throw new ODataNotImplementedException();
    }

    public ODataResponse readEntity(GetEntityUriInfo uriInfo, String contentType) throws ODataException {
        if (uriInfo.getNavigationSegments().size() == 0) {
            int id;
            Map<String, Object> data;
            EdmEntitySet entitySet = uriInfo.getStartEntitySet();
            if ("Cars".equals(entitySet.getName())) {
                int id2 = this.getKeyValue((KeyPredicate)uriInfo.getKeyPredicates().get(0));
                Map<String, Object> data2 = this.dataStore.getCar(id2);
                if (data2 != null) {
                    URI serviceRoot = this.getContext().getPathInfo().getServiceRoot();
                    EntityProviderWriteProperties.ODataEntityProviderPropertiesBuilder propertiesBuilder = EntityProviderWriteProperties.serviceRoot((URI)serviceRoot);
                    return EntityProvider.writeEntry((String)contentType, (EdmEntitySet)entitySet, data2, (EntityProviderWriteProperties)propertiesBuilder.build());
                }
            } else if ("Manufacturers".equals(entitySet.getName()) && (data = this.dataStore.getManufacturer(id = this.getKeyValue((KeyPredicate)uriInfo.getKeyPredicates().get(0)))) != null) {
                URI serviceRoot = this.getContext().getPathInfo().getServiceRoot();
                EntityProviderWriteProperties.ODataEntityProviderPropertiesBuilder propertiesBuilder = EntityProviderWriteProperties.serviceRoot((URI)serviceRoot);
                return EntityProvider.writeEntry((String)contentType, (EdmEntitySet)entitySet, data, (EntityProviderWriteProperties)propertiesBuilder.build());
            }
            throw new ODataNotFoundException(ODataNotFoundException.ENTITY);
        }
        if (uriInfo.getNavigationSegments().size() == 1) {
            EdmEntitySet entitySet = uriInfo.getTargetEntitySet();
            Map<String, Object> data = null;
            if ("Manufacturers".equals(entitySet.getName())) {
                int carKey = this.getKeyValue((KeyPredicate)uriInfo.getKeyPredicates().get(0));
                data = this.dataStore.getManufacturerFor(carKey);
            }
            if (data != null) {
                return EntityProvider.writeEntry((String)contentType, (EdmEntitySet)uriInfo.getTargetEntitySet(), data, (EntityProviderWriteProperties)EntityProviderWriteProperties.serviceRoot((URI)this.getContext().getPathInfo().getServiceRoot()).build());
            }
            throw new ODataNotFoundException(ODataNotFoundException.ENTITY);
        }
        throw new ODataNotImplementedException();
    }

    private int getKeyValue(KeyPredicate key) throws ODataException {
        EdmProperty property = key.getProperty();
        EdmSimpleType type = (EdmSimpleType)property.getType();
        return (Integer)type.valueOfString(key.getLiteral(), EdmLiteralKind.DEFAULT, property.getFacets(), Integer.class);
    }
}

