/*
 * Decompiled with CFR 0.152.
 */
package org.wildfly.camel.test.syslog;

import java.util.Calendar;
import org.apache.camel.Exchange;
import org.apache.camel.ProducerTemplate;
import org.apache.camel.RoutesBuilder;
import org.apache.camel.builder.RouteBuilder;
import org.apache.camel.component.mock.MockEndpoint;
import org.apache.camel.component.syslog.SyslogDataFormat;
import org.apache.camel.component.syslog.SyslogMessage;
import org.apache.camel.impl.DefaultCamelContext;
import org.apache.camel.model.RouteDefinition;
import org.apache.camel.spi.DataFormat;
import org.jboss.arquillian.container.test.api.Deployment;
import org.jboss.arquillian.junit.Arquillian;
import org.jboss.shrinkwrap.api.ShrinkWrap;
import org.jboss.shrinkwrap.api.spec.JavaArchive;
import org.junit.Assert;
import org.junit.Test;
import org.junit.runner.RunWith;
import org.wildfly.camel.test.common.utils.TestUtils;
import org.wildfly.extension.camel.CamelAware;

@CamelAware
@RunWith(value=Arquillian.class)
public class SyslogDataFormatTest {
    private final String SYSLOG_RAW_MESSAGE = "<14>Sep 26 19:30:55 camel-test-host Hello Kermit!";

    @Deployment
    public static JavaArchive createDeployment() {
        return (JavaArchive)((JavaArchive)ShrinkWrap.create(JavaArchive.class, (String)"camel-syslog-tests.jar")).addClass(TestUtils.class);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    public void testSyslogMarshal() throws Exception {
        DefaultCamelContext camelctx = new DefaultCamelContext();
        camelctx.addRoutes((RoutesBuilder)new RouteBuilder(){

            public void configure() throws Exception {
                this.from("direct:start").marshal((DataFormat)new SyslogDataFormat());
            }
        });
        camelctx.start();
        try {
            Calendar calendar = Calendar.getInstance();
            calendar.set(2016, 8, 26, 19, 30, 55);
            SyslogMessage message = new SyslogMessage();
            message.setHostname("camel-test-host");
            message.setLogMessage("Hello Kermit!");
            message.setTimestamp(calendar);
            ProducerTemplate template = camelctx.createProducerTemplate();
            String result = (String)template.requestBody("direct:start", (Object)message, String.class);
            Assert.assertEquals((Object)"<14>Sep 26 19:30:55 camel-test-host Hello Kermit!", (Object)result);
        }
        finally {
            camelctx.stop();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    public void testSyslogUnmarshal() throws Exception {
        final int port = TestUtils.getAvailablePort();
        DefaultCamelContext camelctx = new DefaultCamelContext();
        camelctx.addRoutes((RoutesBuilder)new RouteBuilder(){

            public void configure() throws Exception {
                ((RouteDefinition)this.from("netty4:udp://localhost:" + port + "?sync=false&allowDefaultCodec=false").unmarshal((DataFormat)new SyslogDataFormat())).to("mock:result");
            }
        });
        camelctx.start();
        try {
            MockEndpoint mockEndpoint = (MockEndpoint)camelctx.getEndpoint("mock:result", MockEndpoint.class);
            mockEndpoint.expectedMessageCount(1);
            ProducerTemplate template = camelctx.createProducerTemplate();
            template.requestBody("netty4:udp://127.0.0.1:" + port + "?sync=false&allowDefaultCodec=false&useByteBuf=true", (Object)"<14>Sep 26 19:30:55 camel-test-host Hello Kermit!");
            mockEndpoint.assertIsSatisfied();
            Exchange exchange = (Exchange)mockEndpoint.getReceivedExchanges().get(0);
            SyslogMessage message = (SyslogMessage)exchange.getIn().getBody(SyslogMessage.class);
            Assert.assertEquals((Object)"camel-test-host", (Object)message.getHostname());
            Assert.assertEquals((Object)"Hello Kermit!", (Object)message.getLogMessage());
        }
        finally {
            camelctx.stop();
        }
    }
}

