/*
 * Decompiled with CFR 0.152.
 */
package org.wildfly.camel.test.undertow;

import java.net.URL;
import java.util.List;
import org.apache.camel.ProducerTemplate;
import org.apache.camel.RoutesBuilder;
import org.apache.camel.builder.RouteBuilder;
import org.apache.camel.impl.DefaultCamelContext;
import org.jboss.arquillian.container.test.api.Deployment;
import org.jboss.arquillian.container.test.api.RunAsClient;
import org.jboss.arquillian.junit.Arquillian;
import org.jboss.arquillian.test.api.ArquillianResource;
import org.jboss.as.arquillian.container.ManagementClient;
import org.jboss.shrinkwrap.api.ShrinkWrap;
import org.jboss.shrinkwrap.api.spec.WebArchive;
import org.junit.Assert;
import org.junit.Test;
import org.junit.runner.RunWith;
import org.wildfly.camel.test.http4.subA.MyServlet;
import org.wildfly.extension.camel.EndpointRegistryClient;

@RunAsClient
@RunWith(value=Arquillian.class)
public class UndertowProducerIntegrationTest {
    @ArquillianResource
    ManagementClient managementClient;

    @Deployment
    public static WebArchive createDeployment() {
        WebArchive archive = (WebArchive)ShrinkWrap.create(WebArchive.class, (String)"undertow-producer.war");
        archive.addClasses(new Class[]{MyServlet.class});
        return archive;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    public void testHttpProducer() throws Exception {
        EndpointRegistryClient registryClient = new EndpointRegistryClient(this.managementClient.getControllerClient());
        final String[] endpoints = this.wrapEndpoints(registryClient.getRegisteredEndpoints("/undertow-producer"));
        DefaultCamelContext camelctx = new DefaultCamelContext();
        camelctx.addRoutes((RoutesBuilder)new RouteBuilder(){

            public void configure() throws Exception {
                this.from("direct:start").loadBalance().roundRobin().to(endpoints);
            }
        });
        camelctx.start();
        try {
            ProducerTemplate producer = camelctx.createProducerTemplate();
            String result = (String)producer.requestBodyAndHeader("direct:start", null, "CamelHttpQuery", (Object)"name=Kermit", String.class);
            Assert.assertEquals((Object)"Hello Kermit", (Object)result);
        }
        finally {
            camelctx.stop();
        }
    }

    private String[] wrapEndpoints(List<URL> urls) {
        String[] result = new String[urls.size()];
        for (int i = 0; i < urls.size(); ++i) {
            result[i] = "undertow:" + urls.get(i) + "/myservlet";
        }
        return result;
    }
}

