/*
 * Decompiled with CFR 0.152.
 */
package org.wildfly.camel.test.zipkin;

import com.github.kristofa.brave.SpanCollector;
import java.util.concurrent.TimeUnit;
import org.apache.camel.CamelContext;
import org.apache.camel.Expression;
import org.apache.camel.ProducerTemplate;
import org.apache.camel.RoutesBuilder;
import org.apache.camel.builder.NotifyBuilder;
import org.apache.camel.builder.RouteBuilder;
import org.apache.camel.impl.DefaultCamelContext;
import org.apache.camel.model.RouteDefinition;
import org.apache.camel.zipkin.ZipkinLoggingSpanCollector;
import org.apache.camel.zipkin.ZipkinTracer;
import org.jboss.arquillian.container.test.api.Deployment;
import org.jboss.arquillian.junit.Arquillian;
import org.jboss.shrinkwrap.api.ShrinkWrap;
import org.jboss.shrinkwrap.api.spec.JavaArchive;
import org.junit.Assert;
import org.junit.Test;
import org.junit.runner.RunWith;
import org.wildfly.extension.camel.CamelAware;

@CamelAware
@RunWith(value=Arquillian.class)
public class ZipkinIntegrationTest {
    @Deployment
    public static JavaArchive createDeployment() {
        return (JavaArchive)ShrinkWrap.create(JavaArchive.class, (String)"camel-zipkin-tests");
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    public void testZipkin() throws Exception {
        DefaultCamelContext camelctx = new DefaultCamelContext();
        camelctx.addRoutes((RoutesBuilder)new RouteBuilder(){

            public void configure() throws Exception {
                ((RouteDefinition)this.from("seda:dude").routeId("dude").log("routing at ${routeId}")).delay((Expression)this.simple("${random(1000,2000)}"));
            }
        });
        ZipkinTracer zipkin = new ZipkinTracer();
        zipkin.setServiceName("dude");
        zipkin.setSpanCollector((SpanCollector)new ZipkinLoggingSpanCollector());
        zipkin.init((CamelContext)camelctx);
        NotifyBuilder notify = new NotifyBuilder((CamelContext)camelctx).whenDone(5).create();
        camelctx.start();
        try {
            ProducerTemplate template = camelctx.createProducerTemplate();
            for (int i = 0; i < 5; ++i) {
                template.sendBody("seda:dude", (Object)"Hello World");
            }
            Assert.assertTrue((boolean)notify.matches(30L, TimeUnit.SECONDS));
        }
        finally {
            camelctx.stop();
        }
    }
}

