/*
 * Decompiled with CFR 0.152.
 */
package org.wildfly.camel.test.cdi.subA;

import java.util.concurrent.CountDownLatch;
import javax.resource.spi.IllegalStateException;
import org.apache.camel.CamelContext;
import org.apache.camel.Component;
import org.apache.camel.Exchange;
import org.apache.camel.Processor;
import org.apache.camel.builder.RouteBuilder;
import org.apache.camel.cdi.ContextName;
import org.apache.camel.component.quartz2.QuartzComponent;
import org.apache.camel.model.RouteDefinition;
import org.wildfly.extension.camel.CamelAware;

@CamelAware
@ContextName(value="contextF")
public class RouteBuilderF
extends RouteBuilder {
    public static final String MOCK_RESULT_URI = "mock:result?expectedCount=3";

    public void configure() throws Exception {
        final CountDownLatch startLatch = new CountDownLatch(1);
        this.getContext().addComponent("quartz2", (Component)new QuartzComponent(){

            public void onCamelContextStarted(CamelContext context, boolean alreadyStarted) throws Exception {
                super.onCamelContextStarted(context, alreadyStarted);
                startLatch.countDown();
            }
        });
        ((RouteDefinition)this.from("quartz2://mytimer?trigger.repeatCount=3&trigger.repeatInterval=100").process(new Processor(){

            public void process(Exchange exchange) throws Exception {
                if (startLatch.getCount() > 0L) {
                    throw new IllegalStateException("onCamelContextStarted not called");
                }
            }
        })).to(MOCK_RESULT_URI);
    }
}

