/*
 * Decompiled with CFR 0.152.
 */
package org.wildfly.camel.test.cxf.rs;

import java.io.InputStream;
import javax.ws.rs.client.Client;
import javax.ws.rs.client.ClientBuilder;
import org.apache.camel.CamelContext;
import org.apache.camel.ServiceStatus;
import org.jboss.arquillian.container.test.api.Deployment;
import org.jboss.arquillian.junit.Arquillian;
import org.jboss.arquillian.test.api.ArquillianResource;
import org.jboss.gravia.resource.ManifestBuilder;
import org.jboss.shrinkwrap.api.ShrinkWrap;
import org.jboss.shrinkwrap.api.asset.Asset;
import org.jboss.shrinkwrap.api.spec.JavaArchive;
import org.junit.Assert;
import org.junit.Test;
import org.junit.runner.RunWith;
import org.wildfly.camel.test.common.types.GreetingService;
import org.wildfly.extension.camel.CamelAware;
import org.wildfly.extension.camel.CamelContextRegistry;

@CamelAware
@RunWith(value=Arquillian.class)
public class CXFRSConsumerIntegrationTest {
    @ArquillianResource
    CamelContextRegistry contextRegistry;

    @Deployment
    public static JavaArchive deployment() {
        JavaArchive archive = (JavaArchive)ShrinkWrap.create(JavaArchive.class, (String)"cxfrs-consumer-tests");
        archive.addClasses(new Class[]{GreetingService.class});
        archive.addAsResource("cxf/spring/cxfrs-consumer-camel-context.xml", "cxfrs-consumer-camel-context.xml");
        archive.setManifest(new Asset(){

            public InputStream openStream() {
                ManifestBuilder builder = new ManifestBuilder();
                builder.addManifestHeader("Dependencies", "org.jboss.resteasy.resteasy-jaxrs");
                return builder.openStream();
            }
        });
        return archive;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    public void testCXFConsumer() throws Exception {
        CamelContext camelctx = this.contextRegistry.getCamelContext("cxfrs-undertow");
        Assert.assertNotNull((String)"Expected cxfrs-undertow to not be null", (Object)camelctx);
        Assert.assertEquals((Object)ServiceStatus.Started, (Object)camelctx.getStatus());
        ClassLoader tccl = Thread.currentThread().getContextClassLoader();
        try {
            Thread.currentThread().setContextClassLoader(this.getClass().getClassLoader());
            Client client = ClientBuilder.newClient();
            Object result = client.target("http://localhost:8080/cxfrestful/greet/hello/Kermit").request(new String[]{"application/json"}).get(String.class);
            Assert.assertEquals((Object)"Hello Kermit", (Object)result);
        }
        finally {
            Thread.currentThread().setContextClassLoader(tccl);
        }
    }
}

