/*
 * Decompiled with CFR 0.152.
 */
package org.wildfly.camel.test.cxf.ws;

import org.apache.camel.Expression;
import org.apache.camel.PollingConsumer;
import org.apache.camel.ProducerTemplate;
import org.apache.camel.RoutesBuilder;
import org.apache.camel.builder.RouteBuilder;
import org.apache.camel.impl.DefaultCamelContext;
import org.apache.camel.model.TryDefinition;
import org.jboss.arquillian.container.test.api.Deployer;
import org.jboss.arquillian.container.test.api.Deployment;
import org.jboss.arquillian.junit.Arquillian;
import org.jboss.arquillian.test.api.ArquillianResource;
import org.jboss.as.arquillian.api.ServerSetup;
import org.jboss.as.arquillian.api.ServerSetupTask;
import org.jboss.as.arquillian.container.ManagementClient;
import org.jboss.dmr.ModelNode;
import org.jboss.shrinkwrap.api.Archive;
import org.jboss.shrinkwrap.api.ShrinkWrap;
import org.jboss.shrinkwrap.api.asset.Asset;
import org.jboss.shrinkwrap.api.asset.StringAsset;
import org.jboss.shrinkwrap.api.spec.JavaArchive;
import org.jboss.shrinkwrap.api.spec.WebArchive;
import org.junit.Assert;
import org.junit.Test;
import org.junit.runner.RunWith;
import org.wildfly.camel.test.common.types.Endpoint;
import org.wildfly.camel.test.common.utils.DMRUtils;
import org.wildfly.camel.test.cxf.ws.subA.SecureEndpointImpl;
import org.wildfly.extension.camel.CamelAware;

@CamelAware
@RunWith(value=Arquillian.class)
@ServerSetup(value={SecurityDomainSetup.class})
public class CXFWSSecureProducerIntegrationTest {
    static final String SIMPLE_WAR = "simple.war";
    @ArquillianResource
    Deployer deployer;
    @ArquillianResource
    ManagementClient managementClient;

    @Deployment
    public static JavaArchive deployment() {
        JavaArchive archive = (JavaArchive)ShrinkWrap.create(JavaArchive.class, (String)"cxfws-secure-producer-tests");
        archive.addClasses(new Class[]{Endpoint.class});
        return archive;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    public void testEndpointRouteWithValidCredentials() throws Exception {
        this.deployer.deploy(SIMPLE_WAR);
        try {
            DefaultCamelContext camelctx = new DefaultCamelContext();
            camelctx.addRoutes((RoutesBuilder)new RouteBuilder(){

                public void configure() throws Exception {
                    this.from("direct:start").to("cxf://" + CXFWSSecureProducerIntegrationTest.this.getEndpointAddress("/simple", "cxfuser", "cxfpassword"));
                }
            });
            camelctx.start();
            try {
                ProducerTemplate producer = camelctx.createProducerTemplate();
                String result = (String)producer.requestBody("direct:start", (Object)"Kermit", String.class);
                Assert.assertEquals((Object)"Hello Kermit", (Object)result);
            }
            finally {
                camelctx.stop();
            }
        }
        finally {
            this.deployer.undeploy(SIMPLE_WAR);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    public void testEndpointRouteWithInvalidCredentials() throws Exception {
        this.deployer.deploy(SIMPLE_WAR);
        try {
            DefaultCamelContext camelctx = new DefaultCamelContext();
            camelctx.addRoutes((RoutesBuilder)new RouteBuilder(){

                public void configure() throws Exception {
                    ((TryDefinition)((TryDefinition)((TryDefinition)this.from("direct:start").doTry().to("cxf://" + CXFWSSecureProducerIntegrationTest.this.getEndpointAddress("/simple", "baduser", "badpassword"))).doCatch(Exception.class).setBody((Expression)this.exceptionMessage())).to("direct:error")).end();
                }
            });
            PollingConsumer pollingConsumer = camelctx.getEndpoint("direct:error").createPollingConsumer();
            pollingConsumer.start();
            camelctx.start();
            try {
                ProducerTemplate producer = camelctx.createProducerTemplate();
                producer.requestBody("direct:start", (Object)"Kermit", String.class);
                String result = (String)pollingConsumer.receive(3000L).getIn().getBody(String.class);
                Assert.assertTrue((boolean)result.contains("401: Unauthorized"));
            }
            finally {
                camelctx.stop();
            }
        }
        finally {
            this.deployer.undeploy(SIMPLE_WAR);
        }
    }

    private String getEndpointAddress(String contextPath, String username, String password) {
        StringBuilder builder = new StringBuilder();
        builder.append(this.managementClient.getWebUri()).append(contextPath).append("/EndpointService?username=").append(username).append("&password=").append(password).append("&serviceClass=").append(Endpoint.class.getName());
        return builder.toString();
    }

    @Deployment(name="simple.war", managed=false)
    public static Archive<?> getSimpleWar() {
        WebArchive archive = (WebArchive)ShrinkWrap.create(WebArchive.class, (String)SIMPLE_WAR);
        StringAsset jbossWebAsset = new StringAsset("<jboss-web><security-domain>cxf-security-domain</security-domain></jboss-web>");
        archive.addClasses(new Class[]{Endpoint.class, SecureEndpointImpl.class});
        archive.addAsResource("cxf/secure/cxf-roles.properties", "cxf-roles.properties");
        archive.addAsResource("cxf/secure/cxf-users.properties", "cxf-users.properties");
        archive.addAsWebInfResource((Asset)jbossWebAsset, "jboss-web.xml");
        return archive;
    }

    static class SecurityDomainSetup
    implements ServerSetupTask {
        SecurityDomainSetup() {
        }

        public void setup(ManagementClient managementClient, String containerId) throws Exception {
            ModelNode securityDomainOpAdd = DMRUtils.createOpNode((String)"subsystem=security/security-domain=cxf-security-domain", (String)"add");
            ModelNode securityDomainContent = DMRUtils.createOpNode((String)"subsystem=security/security-domain=cxf-security-domain/authentication=classic", (String)"add");
            ModelNode loginModules = securityDomainContent.get("login-modules");
            ModelNode userRoles = new ModelNode();
            userRoles.get("code").set("UsersRoles");
            userRoles.get("flag").set("required");
            ModelNode moduleOptions = userRoles.get("module-options");
            moduleOptions.get("usersProperties").set("cxf-users.properties");
            moduleOptions.get("rolesProperties").set("cxf-roles.properties");
            loginModules.add(userRoles);
            ModelNode result = managementClient.getControllerClient().execute(DMRUtils.createCompositeNode((ModelNode[])new ModelNode[]{securityDomainOpAdd, securityDomainContent}));
            Assert.assertEquals((Object)"success", (Object)result.get("outcome").asString());
        }

        public void tearDown(ManagementClient managementClient, String containerId) throws Exception {
            ModelNode securityDomainOpRemove = DMRUtils.createOpNode((String)"subsystem=security/security-domain=cxf-security-domain", (String)"remove");
            securityDomainOpRemove.get(new String[]{"operation-headers", "allow-resource-service-restart"}).set(true);
            ModelNode result = managementClient.getControllerClient().execute(securityDomainOpRemove);
            Assert.assertEquals((Object)"success", (Object)result.get("outcome").asString());
        }
    }
}

