/*
 * Decompiled with CFR 0.152.
 */
package org.wildfly.camel.test.dns;

import org.apache.camel.CamelExecutionException;
import org.apache.camel.Endpoint;
import org.apache.camel.ProducerTemplate;
import org.apache.camel.RoutesBuilder;
import org.apache.camel.builder.RouteBuilder;
import org.apache.camel.impl.DefaultCamelContext;
import org.jboss.arquillian.container.test.api.Deployment;
import org.jboss.arquillian.junit.Arquillian;
import org.jboss.shrinkwrap.api.ShrinkWrap;
import org.jboss.shrinkwrap.api.spec.JavaArchive;
import org.junit.Assert;
import org.junit.Test;
import org.junit.runner.RunWith;
import org.wildfly.extension.camel.CamelAware;
import org.xbill.DNS.Record;

@CamelAware
@RunWith(value=Arquillian.class)
public class DnsIntegrationTest {
    @Deployment
    public static JavaArchive createdeployment() {
        return (JavaArchive)ShrinkWrap.create(JavaArchive.class, (String)"camel-dns-tests");
    }

    @Test
    public void testDnsComponent() throws Exception {
        DefaultCamelContext camelctx = new DefaultCamelContext();
        Endpoint endpoint = camelctx.getEndpoint("dns:lookup");
        Assert.assertNotNull((Object)endpoint);
        Assert.assertEquals((Object)endpoint.getClass().getName(), (Object)"org.apache.camel.component.dns.DnsEndpoint");
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    public void testDnsProducer() throws Exception {
        DefaultCamelContext camelctx = new DefaultCamelContext();
        camelctx.addRoutes((RoutesBuilder)new RouteBuilder(){

            public void configure() throws Exception {
                this.from("direct:start").to("dns:lookup");
            }
        });
        camelctx.start();
        try {
            ProducerTemplate producer = camelctx.createProducerTemplate();
            Record[] record = (Record[])producer.requestBodyAndHeader("direct:start", null, "dns.name", (Object)"redhat.com", Record[].class);
            Assert.assertEquals((Object)"redhat.com.", (Object)record[0].getName().toString());
            Assert.assertEquals((long)1L, (long)record[0].getType());
        }
        catch (CamelExecutionException ex) {
            Throwable cause = ex.getCause();
            Assert.assertEquals((Object)"network error", (Object)cause.getMessage());
        }
        finally {
            camelctx.stop();
        }
    }
}

