/*
 * Decompiled with CFR 0.152.
 */
package org.wildfly.camel.test.dozer;

import org.apache.camel.CamelContext;
import org.apache.camel.ProducerTemplate;
import org.apache.camel.ServiceStatus;
import org.jboss.arquillian.container.test.api.Deployment;
import org.jboss.arquillian.junit.Arquillian;
import org.jboss.arquillian.test.api.ArquillianResource;
import org.jboss.shrinkwrap.api.ShrinkWrap;
import org.jboss.shrinkwrap.api.spec.JavaArchive;
import org.junit.Assert;
import org.junit.Test;
import org.junit.runner.RunWith;
import org.wildfly.camel.test.dozer.subA.CustomerA;
import org.wildfly.camel.test.dozer.subA.CustomerB;
import org.wildfly.extension.camel.CamelAware;
import org.wildfly.extension.camel.CamelContextRegistry;

@CamelAware
@RunWith(value=Arquillian.class)
public class DozerSpringIntegrationTest {
    @ArquillianResource
    CamelContextRegistry contextRegistry;

    @Deployment
    public static JavaArchive createdeployment() {
        JavaArchive archive = (JavaArchive)ShrinkWrap.create(JavaArchive.class, (String)"camel-dozer-spring");
        archive.addClasses(new Class[]{CustomerA.class, CustomerB.class});
        archive.addAsResource("dozer/dozer-camel-context.xml", "dozer-camel-context.xml");
        archive.addAsResource("dozer/dozer-mappings.xml", "dozer-mappings.xml");
        return archive;
    }

    @Test
    public void testBeanMapping() throws Exception {
        CamelContext camelctx = this.contextRegistry.getCamelContext("dozer-spring-context");
        Assert.assertEquals((Object)ServiceStatus.Started, (Object)camelctx.getStatus());
        String json = "{" + CustomerA.class.getName() + ":{firstName:John,lastName:Doe,street:Street,zip:1234}}";
        ProducerTemplate template = camelctx.createProducerTemplate();
        CustomerB customer = (CustomerB)template.requestBody("direct:start", (Object)json, CustomerB.class);
        Assert.assertEquals((Object)"John", (Object)customer.getFirstName());
        Assert.assertEquals((Object)"Doe", (Object)customer.getLastName());
        Assert.assertEquals((Object)"Street", (Object)customer.getAddress().getStreet());
        Assert.assertEquals((Object)"1234", (Object)customer.getAddress().getZip());
    }
}

