/*
 * Decompiled with CFR 0.152.
 */
package org.wildfly.camel.test.kafka;

import java.io.InputStream;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Properties;
import java.util.concurrent.CountDownLatch;
import java.util.concurrent.TimeUnit;
import org.apache.camel.ProducerTemplate;
import org.apache.camel.RoutesBuilder;
import org.apache.camel.ServiceStatus;
import org.apache.camel.builder.RouteBuilder;
import org.apache.camel.impl.DefaultCamelContext;
import org.apache.kafka.clients.consumer.ConsumerRecord;
import org.apache.kafka.clients.consumer.ConsumerRecords;
import org.apache.kafka.clients.consumer.KafkaConsumer;
import org.jboss.arquillian.container.test.api.Deployment;
import org.jboss.arquillian.junit.Arquillian;
import org.jboss.gravia.resource.ManifestBuilder;
import org.jboss.shrinkwrap.api.ShrinkWrap;
import org.jboss.shrinkwrap.api.asset.Asset;
import org.jboss.shrinkwrap.api.spec.JavaArchive;
import org.junit.AfterClass;
import org.junit.Assert;
import org.junit.BeforeClass;
import org.junit.Test;
import org.junit.runner.RunWith;
import org.wildfly.camel.test.common.kafka.EmbeddedKafkaCluster;
import org.wildfly.camel.test.common.utils.TestUtils;
import org.wildfly.camel.test.common.zookeeper.EmbeddedZookeeper;
import org.wildfly.camel.test.kafka.subA.SimpleKafkaPartitioner;
import org.wildfly.camel.test.kafka.subA.SimpleKafkaSerializer;
import org.wildfly.extension.camel.CamelAware;

@CamelAware
@RunWith(value=Arquillian.class)
public class KafkaProducerIntegrationTest {
    private static final String TOPIC_STRINGS = "test";
    private static final String TOPIC_STRINGS_IN_HEADER = "testHeader";
    private static final int KAFKA_PORT = 9092;
    static EmbeddedZookeeper embeddedZookeeper;
    static EmbeddedKafkaCluster embeddedKafkaCluster;

    @Deployment
    public static JavaArchive deployment() {
        JavaArchive archive = (JavaArchive)ShrinkWrap.create(JavaArchive.class, (String)"kafka-producer-tests.jar");
        archive.addPackage(EmbeddedKafkaCluster.class.getPackage());
        archive.addPackage(EmbeddedZookeeper.class.getPackage());
        archive.addClasses(new Class[]{SimpleKafkaSerializer.class, SimpleKafkaPartitioner.class, TestUtils.class});
        archive.setManifest(new Asset(){

            public InputStream openStream() {
                ManifestBuilder builder = new ManifestBuilder();
                builder.addManifestHeader("Dependencies", "org.apache.kafka");
                return builder.openStream();
            }
        });
        return archive;
    }

    @BeforeClass
    public static void before() throws Exception {
        embeddedZookeeper = new EmbeddedZookeeper();
        List<Integer> kafkaPorts = Collections.singletonList(9092);
        embeddedKafkaCluster = new EmbeddedKafkaCluster(embeddedZookeeper.getConnection(), new Properties(), kafkaPorts);
        embeddedZookeeper.startup(1, TimeUnit.SECONDS);
        System.out.println("### Embedded Zookeeper connection: " + embeddedZookeeper.getConnection());
        embeddedKafkaCluster.startup();
        System.out.println("### Embedded Kafka cluster broker list: " + embeddedKafkaCluster.getBrokerList());
    }

    @AfterClass
    public static void after() throws Exception {
        try {
            embeddedKafkaCluster.shutdown();
        }
        catch (Exception ex) {
            ex.printStackTrace();
        }
        try {
            embeddedZookeeper.shutdown();
        }
        catch (Exception ex) {
            ex.printStackTrace();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    public void producedStringMessageIsReceivedByKafka() throws Exception {
        final String epuri = "kafka:localhost:9092?topic=test&requestRequiredAcks=-1";
        DefaultCamelContext camelctx = new DefaultCamelContext();
        camelctx.addRoutes((RoutesBuilder)new RouteBuilder(){

            public void configure() throws Exception {
                this.from("direct:start").to(epuri);
            }
        });
        camelctx.start();
        try {
            boolean allReceived;
            ProducerTemplate template = camelctx.createProducerTemplate();
            this.sendMessagesInRoute(10, template, (Object)"IT test message", "kafka.PARTITION_KEY", "1");
            this.sendMessagesInRoute(5, template, (Object)"IT test message in other topic", "kafka.PARTITION_KEY", "1", "kafka.TOPIC", TOPIC_STRINGS_IN_HEADER);
            CountDownLatch latch = new CountDownLatch(15);
            try (KafkaConsumer<String, String> consumer = this.createKafkaConsumer();){
                this.consumeKafkaMessages(consumer, TOPIC_STRINGS, TOPIC_STRINGS_IN_HEADER, latch);
                allReceived = latch.await(2L, TimeUnit.SECONDS);
            }
            Assert.assertTrue((String)("Messages published to the kafka topics were received: " + latch.getCount()), (boolean)allReceived);
        }
        finally {
            camelctx.stop();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    public void testCustomKafkaSerializer() throws Exception {
        String serializer = "&serializerClass=" + SimpleKafkaSerializer.class.getName();
        final String epuri = "kafka:localhost:9092?topic=test&requestRequiredAcks=-1" + serializer;
        DefaultCamelContext camelctx = new DefaultCamelContext();
        camelctx.addRoutes((RoutesBuilder)new RouteBuilder(){

            public void configure() throws Exception {
                this.from("direct:start").to(epuri);
            }
        });
        camelctx.start();
        try {
            Assert.assertEquals((Object)ServiceStatus.Started, (Object)camelctx.getStatus());
        }
        finally {
            camelctx.stop();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    public void testCustomKafkaPartitioner() throws Exception {
        String partitioner = "&partitioner=" + SimpleKafkaPartitioner.class.getName();
        final String epuri = "kafka:localhost:9092?topic=test&requestRequiredAcks=-1" + partitioner;
        DefaultCamelContext camelctx = new DefaultCamelContext();
        camelctx.addRoutes((RoutesBuilder)new RouteBuilder(){

            public void configure() throws Exception {
                this.from("direct:start").to(epuri);
            }
        });
        camelctx.start();
        try {
            Assert.assertEquals((Object)ServiceStatus.Started, (Object)camelctx.getStatus());
        }
        finally {
            camelctx.stop();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private KafkaConsumer<String, String> createKafkaConsumer() {
        Properties stringsProps = new Properties();
        stringsProps.put("bootstrap.servers", "localhost:9092");
        stringsProps.put("group.id", "DemoConsumer");
        stringsProps.put("enable.auto.commit", "true");
        stringsProps.put("auto.commit.interval.ms", "1000");
        stringsProps.put("session.timeout.ms", "30000");
        stringsProps.put("key.deserializer", "org.apache.kafka.common.serialization.StringDeserializer");
        stringsProps.put("value.deserializer", "org.apache.kafka.common.serialization.StringDeserializer");
        stringsProps.put("auto.offset.reset", "earliest");
        ClassLoader tccl = Thread.currentThread().getContextClassLoader();
        try {
            Thread.currentThread().setContextClassLoader(this.getClass().getClassLoader());
            KafkaConsumer kafkaConsumer = new KafkaConsumer(stringsProps);
            return kafkaConsumer;
        }
        finally {
            Thread.currentThread().setContextClassLoader(tccl);
        }
    }

    private void consumeKafkaMessages(KafkaConsumer<String, String> consumerConn, String topic, String topicInHeader, CountDownLatch messagesLatch) {
        consumerConn.subscribe(Arrays.asList(topic, topicInHeader));
        boolean run = true;
        while (run) {
            ConsumerRecords records = consumerConn.poll(100L);
            for (ConsumerRecord record : records) {
                messagesLatch.countDown();
                if (messagesLatch.getCount() != 0L) continue;
                run = false;
            }
        }
    }

    private void sendMessagesInRoute(int messages, ProducerTemplate template, Object bodyOther, String ... headersWithValue) {
        HashMap<String, Object> headerMap = new HashMap<String, Object>();
        for (int i = 0; i < headersWithValue.length; i += 2) {
            headerMap.put(headersWithValue[i], headersWithValue[i + 1]);
        }
        this.sendMessagesInRoute(messages, template, bodyOther, headerMap);
    }

    private void sendMessagesInRoute(int messages, ProducerTemplate template, Object bodyOther, Map<String, Object> headerMap) {
        for (int k = 0; k < messages; ++k) {
            template.sendBodyAndHeaders("direct:start", bodyOther, headerMap);
        }
    }
}

