/*
 * Decompiled with CFR 0.152.
 */
package org.wildfly.camel.test.netty;

import javax.naming.InitialContext;
import org.apache.camel.RoutesBuilder;
import org.apache.camel.builder.RouteBuilder;
import org.apache.camel.impl.DefaultCamelContext;
import org.apache.camel.util.jsse.KeyManagersParameters;
import org.apache.camel.util.jsse.KeyStoreParameters;
import org.apache.camel.util.jsse.SSLContextParameters;
import org.apache.camel.util.jsse.TrustManagersParameters;
import org.jboss.arquillian.container.test.api.Deployment;
import org.jboss.arquillian.junit.Arquillian;
import org.jboss.arquillian.test.api.ArquillianResource;
import org.jboss.shrinkwrap.api.ShrinkWrap;
import org.jboss.shrinkwrap.api.spec.JavaArchive;
import org.junit.After;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Test;
import org.junit.runner.RunWith;

@RunWith(value=Arquillian.class)
public class SecureNettyIntegrationTest {
    private static final String KEYSTORE = "keystore.jks";
    private static final String KEYSTORE_PASSWORD = "secret";
    private static final String SOCKET_HOST = "localhost";
    private static final int SOCKET_PORT = 7999;
    @ArquillianResource
    private InitialContext initialContext;

    @Before
    public void setUp() throws Exception {
        KeyStoreParameters ksp = new KeyStoreParameters();
        ksp.setResource("/keystore.jks");
        ksp.setPassword(KEYSTORE_PASSWORD);
        KeyManagersParameters kmp = new KeyManagersParameters();
        kmp.setKeyPassword(KEYSTORE_PASSWORD);
        kmp.setKeyStore(ksp);
        TrustManagersParameters tmp = new TrustManagersParameters();
        tmp.setKeyStore(ksp);
        SSLContextParameters scp = new SSLContextParameters();
        scp.setKeyManagers(kmp);
        scp.setTrustManagers(tmp);
        InitialContext context = new InitialContext();
        context.bind("sslContextParameters", (Object)scp);
    }

    @After
    public void tearDown() throws Exception {
        this.initialContext.unbind("sslContextParameters");
    }

    @Deployment
    public static JavaArchive createdeployment() {
        JavaArchive archive = (JavaArchive)ShrinkWrap.create(JavaArchive.class, (String)"camel-netty-test.jar");
        archive.addAsManifestResource("netty/secure-netty-camel-context.xml");
        archive.addAsResource("netty/keystore.jks", KEYSTORE);
        return archive;
    }

    @Test
    public void testNettySecureTcpSocket() throws Exception {
        DefaultCamelContext camelctx = new DefaultCamelContext();
        camelctx.addRoutes((RoutesBuilder)new RouteBuilder(){

            public void configure() throws Exception {
                this.from("direct:start").to("netty4:tcp://localhost:7999?textline=true&ssl=true&sslContextParameters=#sslContextParameters");
            }
        });
        camelctx.start();
        try {
            String result = (String)camelctx.createProducerTemplate().requestBody("direct:start", (Object)"Kermit", String.class);
            Assert.assertEquals((Object)"Hello Kermit", (Object)result);
        }
        finally {
            camelctx.stop();
        }
    }
}

