/*
 * Decompiled with CFR 0.152.
 */
package org.wildfly.camel.test.quartz2;

import java.util.concurrent.CountDownLatch;
import java.util.concurrent.TimeUnit;
import org.apache.camel.CamelContext;
import org.apache.camel.Component;
import org.apache.camel.Exchange;
import org.apache.camel.Processor;
import org.apache.camel.RoutesBuilder;
import org.apache.camel.builder.RouteBuilder;
import org.apache.camel.component.quartz2.QuartzComponent;
import org.apache.camel.impl.DefaultCamelContext;
import org.apache.camel.model.RouteDefinition;
import org.jboss.arquillian.container.test.api.Deployment;
import org.jboss.arquillian.junit.Arquillian;
import org.jboss.shrinkwrap.api.ShrinkWrap;
import org.jboss.shrinkwrap.api.spec.JavaArchive;
import org.junit.Assert;
import org.junit.Test;
import org.junit.runner.RunWith;
import org.quartz.Scheduler;
import org.wildfly.extension.camel.CamelAware;

@CamelAware
@RunWith(value=Arquillian.class)
public class QuartzIntegrationTest {
    @Deployment
    public static JavaArchive deployment() {
        JavaArchive archive = (JavaArchive)ShrinkWrap.create(JavaArchive.class, (String)"quartz-tests");
        return archive;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    public void testScheduler() throws Exception {
        final CountDownLatch procLatch = new CountDownLatch(3);
        ClassLoader loader = QuartzIntegrationTest.class.getClassLoader();
        Class<?> sclass = loader.loadClass("org.quartz.Scheduler");
        Assert.assertNotNull((String)"Scheduler can be loaded", sclass);
        DefaultCamelContext camelctx = new DefaultCamelContext();
        camelctx.addRoutes((RoutesBuilder)new RouteBuilder(){

            public void configure() throws Exception {
                ((RouteDefinition)this.from("quartz2://mytimer?trigger.repeatCount=3&trigger.repeatInterval=100").process(new Processor(){

                    public void process(Exchange exchange) throws Exception {
                        CamelContext context = exchange.getContext();
                        QuartzComponent comp = (QuartzComponent)context.getComponent("quartz2", QuartzComponent.class);
                        Scheduler scheduler = comp.getScheduler();
                        Assert.assertNotNull((String)"Scheduler not null", (Object)scheduler);
                        procLatch.countDown();
                    }
                })).to("mock:result");
            }
        });
        camelctx.start();
        try {
            Assert.assertTrue((String)"ProcLatch reached zero", (boolean)procLatch.await(500L, TimeUnit.MILLISECONDS));
        }
        finally {
            camelctx.stop();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    public void testManualComponentConfig() throws Exception {
        final CountDownLatch startLatch = new CountDownLatch(1);
        final CountDownLatch procLatch = new CountDownLatch(3);
        DefaultCamelContext camelctx = new DefaultCamelContext();
        camelctx.addComponent("quartz2", (Component)new QuartzComponent(){

            public void onCamelContextStarted(CamelContext context, boolean alreadyStarted) throws Exception {
                super.onCamelContextStarted(context, alreadyStarted);
                if (!alreadyStarted) {
                    startLatch.countDown();
                }
            }
        });
        camelctx.addRoutes((RoutesBuilder)new RouteBuilder(){

            public void configure() throws Exception {
                ((RouteDefinition)this.from("quartz2://mytimer?trigger.repeatCount=3&trigger.repeatInterval=100").process(new Processor(){

                    public void process(Exchange exchange) throws Exception {
                        procLatch.countDown();
                    }
                })).to("mock:result");
            }
        });
        camelctx.start();
        try {
            Assert.assertEquals((String)"StartLatch is zero", (long)0L, (long)startLatch.getCount());
            Assert.assertTrue((String)"ProcLatch reached zero", (boolean)procLatch.await(500L, TimeUnit.MILLISECONDS));
        }
        finally {
            camelctx.stop();
        }
    }
}

