/*
 * Decompiled with CFR 0.152.
 */
package org.wildfly.camel.test.barcode;

import java.io.BufferedInputStream;
import java.io.File;
import java.io.InputStream;
import org.apache.camel.ProducerTemplate;
import org.apache.camel.RoutesBuilder;
import org.apache.camel.builder.RouteBuilder;
import org.apache.camel.dataformat.barcode.BarcodeDataFormat;
import org.apache.camel.impl.DefaultCamelContext;
import org.apache.camel.model.RouteDefinition;
import org.apache.camel.spi.DataFormat;
import org.jboss.arquillian.container.test.api.Deployment;
import org.jboss.arquillian.junit.Arquillian;
import org.jboss.shrinkwrap.api.ShrinkWrap;
import org.jboss.shrinkwrap.api.spec.JavaArchive;
import org.junit.Assert;
import org.junit.Test;
import org.junit.runner.RunWith;
import org.wildfly.extension.camel.CamelAware;

@CamelAware
@RunWith(value=Arquillian.class)
public class BarcodeDataformatTest {
    @Deployment
    public static JavaArchive createDeployment() {
        return (JavaArchive)((JavaArchive)ShrinkWrap.create(JavaArchive.class, (String)"camel-barcode-tests.jar")).addAsResource("barcode/barcode.png", "barcode.png");
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    public void testBarcodeMarshal() throws Exception {
        DefaultCamelContext camelctx = new DefaultCamelContext();
        camelctx.addRoutes((RoutesBuilder)new RouteBuilder(){

            public void configure() throws Exception {
                ((RouteDefinition)this.from("direct:start").marshal((DataFormat)new BarcodeDataFormat())).to("file://target?fileName=barcode.png");
            }
        });
        camelctx.start();
        try {
            ProducerTemplate template = camelctx.createProducerTemplate();
            template.requestBody("direct:start", (Object)"Barcode Test Content");
            File file = new File("target/barcode.png");
            Assert.assertTrue((boolean)file.exists());
            Assert.assertTrue((file.length() > 0L ? 1 : 0) != 0);
        }
        finally {
            camelctx.stop();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    public void testBarcodeUnmarshal() throws Exception {
        DefaultCamelContext camelctx = new DefaultCamelContext();
        camelctx.addRoutes((RoutesBuilder)new RouteBuilder(){

            public void configure() throws Exception {
                this.from("direct:start").unmarshal((DataFormat)new BarcodeDataFormat());
            }
        });
        camelctx.start();
        try {
            InputStream resource = this.getClass().getClassLoader().getResourceAsStream("barcode.png");
            BufferedInputStream bis = new BufferedInputStream(resource);
            ProducerTemplate template = camelctx.createProducerTemplate();
            String result = (String)template.requestBody("direct:start", (Object)bis, String.class);
            Assert.assertEquals((Object)"Barcode Test Content", (Object)result);
        }
        finally {
            camelctx.stop();
        }
    }
}

