/*
 * Decompiled with CFR 0.152.
 */
package org.wildfly.camel.test.beanio;

import java.util.List;
import org.apache.camel.ProducerTemplate;
import org.apache.camel.RoutesBuilder;
import org.apache.camel.builder.RouteBuilder;
import org.apache.camel.dataformat.beanio.BeanIODataFormat;
import org.apache.camel.impl.DefaultCamelContext;
import org.apache.camel.spi.DataFormat;
import org.jboss.arquillian.container.test.api.Deployment;
import org.jboss.arquillian.junit.Arquillian;
import org.jboss.shrinkwrap.api.ShrinkWrap;
import org.jboss.shrinkwrap.api.spec.JavaArchive;
import org.junit.Assert;
import org.junit.Test;
import org.junit.runner.RunWith;
import org.wildfly.camel.test.beanio.subA.Customer;
import org.wildfly.extension.camel.CamelAware;

@CamelAware
@RunWith(value=Arquillian.class)
public class BeanIOIntegrationTest {
    private static final String MAPPINGS_XML = "beanio-mappings.xml";

    @Deployment
    public static JavaArchive createdeployment() {
        JavaArchive archive = (JavaArchive)ShrinkWrap.create(JavaArchive.class, (String)"camel-beanio-tests");
        archive.addClasses(new Class[]{Customer.class});
        archive.addAsResource("beanio/beanio-mappings.xml", MAPPINGS_XML);
        return archive;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    public void testMarshal() throws Exception {
        BeanIODataFormat beanio = new BeanIODataFormat(MAPPINGS_XML, "customerStream");
        DefaultCamelContext camelctx = new DefaultCamelContext();
        camelctx.addRoutes((RoutesBuilder)new RouteBuilder((DataFormat)beanio){
            final /* synthetic */ DataFormat val$beanio;
            {
                this.val$beanio = dataFormat;
            }

            public void configure() throws Exception {
                this.from("direct:start").marshal(this.val$beanio);
            }
        });
        camelctx.start();
        try {
            ProducerTemplate producer = camelctx.createProducerTemplate();
            Customer customer = new Customer("Peter", "Post", "Street", "12345");
            String result = (String)producer.requestBody("direct:start", (Object)customer, String.class);
            Assert.assertEquals((Object)"Peter,Post,Street,12345", (Object)result.trim());
        }
        finally {
            camelctx.stop();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    public void testUnmarshal() throws Exception {
        BeanIODataFormat beanio = new BeanIODataFormat(MAPPINGS_XML, "customerStream");
        DefaultCamelContext camelctx = new DefaultCamelContext();
        camelctx.addRoutes((RoutesBuilder)new RouteBuilder((DataFormat)beanio){
            final /* synthetic */ DataFormat val$beanio;
            {
                this.val$beanio = dataFormat;
            }

            public void configure() throws Exception {
                this.from("direct:start").unmarshal(this.val$beanio);
            }
        });
        camelctx.start();
        try {
            ProducerTemplate producer = camelctx.createProducerTemplate();
            List result = (List)producer.requestBody("direct:start", (Object)"Peter,Post,Street,12345", List.class);
            Assert.assertEquals((long)1L, (long)result.size());
            Customer customer = (Customer)result.get(0);
            Assert.assertEquals((Object)"Peter", (Object)customer.getFirstName());
            Assert.assertEquals((Object)"Post", (Object)customer.getLastName());
            Assert.assertEquals((Object)"Street", (Object)customer.getStreet());
            Assert.assertEquals((Object)"12345", (Object)customer.getZip());
        }
        finally {
            camelctx.stop();
        }
    }
}

