/*
 * Decompiled with CFR 0.152.
 */
package org.wildfly.camel.test.beanvalidator;

import java.util.Set;
import javax.validation.ConstraintViolation;
import org.apache.camel.CamelExecutionException;
import org.apache.camel.ProducerTemplate;
import org.apache.camel.RoutesBuilder;
import org.apache.camel.builder.RouteBuilder;
import org.apache.camel.component.bean.validator.BeanValidationException;
import org.apache.camel.impl.DefaultCamelContext;
import org.jboss.arquillian.container.test.api.Deployment;
import org.jboss.arquillian.junit.Arquillian;
import org.jboss.shrinkwrap.api.ShrinkWrap;
import org.jboss.shrinkwrap.api.spec.JavaArchive;
import org.junit.Assert;
import org.junit.Test;
import org.junit.runner.RunWith;
import org.wildfly.camel.test.beanvalidator.subA.CarWithoutAnnotations;
import org.wildfly.extension.camel.CamelAware;

@CamelAware
@RunWith(value=Arquillian.class)
public class BeanValidatorXMLIntegrationTest {
    @Deployment
    public static JavaArchive deployment() {
        JavaArchive archive = (JavaArchive)ShrinkWrap.create(JavaArchive.class, (String)"bean-validator-xml-tests");
        archive.addPackage(CarWithoutAnnotations.class.getPackage());
        archive.addAsManifestResource("beanvalidator/validation.xml", "validation.xml");
        archive.addAsResource("beanvalidator/constraints-car.xml", "constraints-car.xml");
        return archive;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    public void testBeanValidationSuccess() throws Exception {
        DefaultCamelContext camelctx = new DefaultCamelContext();
        camelctx.addRoutes((RoutesBuilder)new RouteBuilder(){

            public void configure() throws Exception {
                this.from("direct:start").to("bean-validator://validate");
            }
        });
        camelctx.start();
        try {
            CarWithoutAnnotations car = new CarWithoutAnnotations("BMW", "DD-AB-123");
            ProducerTemplate template = camelctx.createProducerTemplate();
            CarWithoutAnnotations result = (CarWithoutAnnotations)template.requestBody("direct:start", (Object)car, CarWithoutAnnotations.class);
            Assert.assertSame((Object)car, (Object)result);
        }
        finally {
            camelctx.stop();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    public void testBeanValidationFailure() throws Exception {
        DefaultCamelContext camelctx = new DefaultCamelContext();
        camelctx.addRoutes((RoutesBuilder)new RouteBuilder(){

            public void configure() throws Exception {
                this.from("direct:start").to("bean-validator://validate");
            }
        });
        camelctx.start();
        try {
            CarWithoutAnnotations CarWithoutAnnotations2 = new CarWithoutAnnotations("BMW", null);
            ProducerTemplate template = camelctx.createProducerTemplate();
            template.requestBody("direct:start", (Object)CarWithoutAnnotations2);
            Assert.fail((String)"Expected BeanValidationException to be thrown");
        }
        catch (CamelExecutionException e) {
            Assert.assertTrue((boolean)(e.getExchange().getException() instanceof BeanValidationException));
            BeanValidationException bve = (BeanValidationException)e.getExchange().getException();
            Set constraintViolations = bve.getConstraintViolations();
            Assert.assertEquals((long)1L, (long)constraintViolations.size());
            ConstraintViolation constraintViolation = (ConstraintViolation)constraintViolations.iterator().next();
            Assert.assertEquals((Object)"licensePlate", (Object)constraintViolation.getPropertyPath().toString());
            Assert.assertEquals(null, (Object)constraintViolation.getInvalidValue());
            Assert.assertEquals((Object)"may not be null", (Object)constraintViolation.getMessage());
        }
        finally {
            camelctx.stop();
        }
    }
}

