/*
 * Decompiled with CFR 0.152.
 */
package org.wildfly.camel.test.context;

import org.apache.camel.CamelContext;
import org.apache.camel.ProducerTemplate;
import org.jboss.arquillian.container.test.api.Deployment;
import org.jboss.arquillian.junit.Arquillian;
import org.jboss.arquillian.test.api.ArquillianResource;
import org.jboss.shrinkwrap.api.ShrinkWrap;
import org.jboss.shrinkwrap.api.asset.Asset;
import org.jboss.shrinkwrap.api.asset.EmptyAsset;
import org.jboss.shrinkwrap.api.spec.JavaArchive;
import org.junit.Assert;
import org.junit.Test;
import org.junit.runner.RunWith;
import org.wildfly.camel.test.common.types.HelloBean;
import org.wildfly.camel.test.context.subA.CamelContextA;
import org.wildfly.extension.camel.CamelAware;
import org.wildfly.extension.camel.CamelContextRegistry;

@CamelAware
@RunWith(value=Arquillian.class)
public class ContextIntegrationTest {
    @ArquillianResource
    CamelContextRegistry camelContextRegistry;

    @Deployment
    public static JavaArchive createDeployment() {
        return (JavaArchive)((JavaArchive)((JavaArchive)((JavaArchive)ShrinkWrap.create(JavaArchive.class, (String)"camel-context-tests.jar")).addClass(HelloBean.class)).addPackage(CamelContextA.class.getPackage())).addAsManifestResource((Asset)EmptyAsset.INSTANCE, "beans.xml");
    }

    @Test
    public void testContextComponent() throws Exception {
        CamelContext contextA = this.camelContextRegistry.getCamelContext("contextA");
        Assert.assertNotNull((String)"Expected contextA to not be null", (Object)contextA);
        CamelContext contextB = this.camelContextRegistry.getCamelContext("contextB");
        Assert.assertNotNull((String)"Expected contextB to not be null", (Object)contextB);
        ProducerTemplate template = contextB.createProducerTemplate();
        String result = (String)template.requestBody("direct:start", (Object)"Kermit", String.class);
        Assert.assertEquals((Object)"Hello Kermit", (Object)result);
    }
}

