/*
 * Decompiled with CFR 0.152.
 */
package org.wildfly.camel.test.elasticsearch.subA;

import java.nio.file.Path;
import java.nio.file.Paths;
import javax.enterprise.inject.Disposes;
import javax.enterprise.inject.Produces;
import javax.inject.Singleton;
import org.elasticsearch.client.Client;
import org.elasticsearch.common.settings.Settings;
import org.elasticsearch.node.NodeBuilder;

public class ElasticSearchClientProducer {
    public static final Path DATA_PATH = Paths.get("target", "elasticsearch", "data");
    public static final Path HOME_PATH = Paths.get("target", "elasticsearch", "home");

    @Produces
    @Singleton
    public Client getClient() {
        Settings.Builder settings = Settings.settingsBuilder().put("http.enabled", false).put(new Object[]{"path.data", DATA_PATH}).put(new Object[]{"path.home", HOME_PATH});
        return NodeBuilder.nodeBuilder().local(true).settings(settings).node().client();
    }

    public void close(@Disposes Client client) {
        client.close();
    }
}

