/*
 * Decompiled with CFR 0.152.
 */
package org.wildfly.camel.test.elsql;

import java.util.List;
import java.util.Map;
import org.apache.camel.Exchange;
import org.apache.camel.ProducerTemplate;
import org.apache.camel.RoutesBuilder;
import org.apache.camel.builder.RouteBuilder;
import org.apache.camel.component.mock.MockEndpoint;
import org.apache.camel.impl.DefaultCamelContext;
import org.jboss.arquillian.container.test.api.Deployment;
import org.jboss.arquillian.junit.Arquillian;
import org.jboss.shrinkwrap.api.ShrinkWrap;
import org.jboss.shrinkwrap.api.spec.JavaArchive;
import org.junit.Assert;
import org.junit.Test;
import org.junit.runner.RunWith;
import org.wildfly.extension.camel.CamelAware;

@CamelAware
@RunWith(value=Arquillian.class)
public class ElSQLIntegrationTest {
    @Deployment
    public static JavaArchive createDeployment() {
        return (JavaArchive)((JavaArchive)ShrinkWrap.create(JavaArchive.class, (String)"camel-elsql-tests.jar")).addAsResource("elsql/users.elsql", "users.elsql");
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    public void testElSQLConsumer() throws Exception {
        DefaultCamelContext camelctx = new DefaultCamelContext();
        camelctx.addRoutes((RoutesBuilder)new RouteBuilder(){

            public void configure() throws Exception {
                this.from("elsql:dbusers:users.elsql?dataSource=java:jboss/datasources/ExampleDS").to("mock:end");
            }
        });
        MockEndpoint mockEndpoint = (MockEndpoint)camelctx.getEndpoint("mock:end", MockEndpoint.class);
        mockEndpoint.expectedMessageCount(1);
        camelctx.start();
        try {
            mockEndpoint.assertIsSatisfied();
            List exchanges = mockEndpoint.getReceivedExchanges();
            Assert.assertEquals((Object)"SA", ((Map)((Exchange)exchanges.get(0)).getIn().getBody(Map.class)).get("NAME"));
        }
        finally {
            camelctx.stop();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    public void testElSQLProducer() throws Exception {
        DefaultCamelContext camelctx = new DefaultCamelContext();
        camelctx.addRoutes((RoutesBuilder)new RouteBuilder(){

            public void configure() throws Exception {
                this.from("direct:start").to("elsql:dbusers:users.elsql?dataSource=java:jboss/datasources/ExampleDS");
            }
        });
        camelctx.start();
        try {
            ProducerTemplate template = camelctx.createProducerTemplate();
            List result = (List)template.requestBody("direct:start", null, List.class);
            Map row = (Map)result.get(0);
            Assert.assertEquals((Object)"SA", row.get("NAME"));
        }
        finally {
            camelctx.stop();
        }
    }
}

