/*
 * Decompiled with CFR 0.152.
 */
package org.wildfly.camel.test.git;

import java.nio.file.Files;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.nio.file.attribute.FileAttribute;
import org.apache.camel.Exchange;
import org.apache.camel.ProducerTemplate;
import org.apache.camel.RoutesBuilder;
import org.apache.camel.builder.RouteBuilder;
import org.apache.camel.component.mock.MockEndpoint;
import org.apache.camel.impl.DefaultCamelContext;
import org.eclipse.jgit.revwalk.RevCommit;
import org.jboss.arquillian.container.test.api.Deployment;
import org.jboss.arquillian.junit.Arquillian;
import org.jboss.shrinkwrap.api.ShrinkWrap;
import org.jboss.shrinkwrap.api.spec.JavaArchive;
import org.junit.Assert;
import org.junit.Test;
import org.junit.runner.RunWith;
import org.wildfly.extension.camel.CamelAware;

@CamelAware
@RunWith(value=Arquillian.class)
public class GitIntegrationTest {
    private static final String GIT_FILE = "myFile.txt";
    private static final Path GIT_REPO = Paths.get("target/repository", new String[0]);
    private static final Path GIT_REPO_FILE = GIT_REPO.resolve("myFile.txt");

    @Deployment
    public static JavaArchive createDeployment() {
        return (JavaArchive)ShrinkWrap.create(JavaArchive.class, (String)"camel-git-tests.jar");
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    public void testGitEndpoint() throws Exception {
        DefaultCamelContext camelctx = new DefaultCamelContext();
        camelctx.addRoutes((RoutesBuilder)new RouteBuilder(){

            public void configure() throws Exception {
                this.from("git://" + GIT_REPO + "?type=commit").to("mock:end");
            }
        });
        MockEndpoint mockEndpoint = (MockEndpoint)camelctx.getEndpoint("mock:end", MockEndpoint.class);
        mockEndpoint.expectedMessageCount(1);
        camelctx.start();
        try {
            String endpointURI = "git://" + GIT_REPO;
            ProducerTemplate template = camelctx.createProducerTemplate();
            template.sendBody(endpointURI + "?operation=init", null);
            Files.createFile(GIT_REPO_FILE, new FileAttribute[0]);
            template.sendBodyAndHeader(endpointURI + "?operation=add", null, "CamelGitFilename", (Object)GIT_FILE);
            template.sendBodyAndHeader(endpointURI + "?operation=commit", (Object)"", "CamelGitCommitMessage", (Object)"Hello Kermit");
            mockEndpoint.assertIsSatisfied();
            Exchange exchange = (Exchange)mockEndpoint.getExchanges().get(0);
            RevCommit commit = (RevCommit)exchange.getOut().getBody(RevCommit.class);
            Assert.assertEquals((Object)"Hello Kermit", (Object)commit.getFullMessage());
        }
        finally {
            camelctx.stop();
        }
    }
}

