/*
 * Decompiled with CFR 0.152.
 */
package org.wildfly.camel.test.jbpm;

import org.apache.camel.ProducerTemplate;
import org.apache.camel.RoutesBuilder;
import org.apache.camel.builder.RouteBuilder;
import org.apache.camel.impl.DefaultCamelContext;
import org.apache.camel.model.RouteDefinition;
import org.jboss.arquillian.container.test.api.Deployment;
import org.jboss.arquillian.junit.Arquillian;
import org.jboss.shrinkwrap.api.ShrinkWrap;
import org.jboss.shrinkwrap.api.spec.JavaArchive;
import org.junit.Assert;
import org.junit.Test;
import org.junit.runner.RunWith;
import org.wildfly.extension.camel.CamelAware;

@CamelAware
@RunWith(value=Arquillian.class)
public class JBPMIntegrationTest {
    @Deployment
    public static JavaArchive createdeployment() {
        return (JavaArchive)ShrinkWrap.create(JavaArchive.class, (String)"camel-jbpm-tests");
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    public void interactsOverRest() throws Exception {
        DefaultCamelContext camelctx = new DefaultCamelContext();
        camelctx.addRoutes((RoutesBuilder)new RouteBuilder(){

            public void configure() throws Exception {
                ((RouteDefinition)this.from("direct:start").to("jbpm:http://localhost:8080/business-central?userName=bpmsAdmin&password=pa$word1&deploymentId=org.kie.example:project1:1.0.0-SNAPSHOT")).to("mock:result");
            }
        });
        camelctx.start();
        try {
            ProducerTemplate producer = camelctx.createProducerTemplate();
            try {
                producer.sendBodyAndHeader("direct:start", null, "CamelJBPMProcessId", (Object)"project1.integration-test");
                Assert.fail((String)"RemoteCommunicationException expected");
            }
            catch (Exception ex) {
                Throwable cause = ex.getCause();
                Assert.assertTrue((String)("Unexpected: " + cause), (boolean)cause.getMessage().contains("404"));
            }
        }
        finally {
            camelctx.stop();
        }
    }
}

