/*
 * Decompiled with CFR 0.152.
 */
package org.wildfly.camel.test.jcache;

import java.util.HashMap;
import java.util.UUID;
import org.apache.camel.Exchange;
import org.apache.camel.Predicate;
import org.apache.camel.ProducerTemplate;
import org.apache.camel.RoutesBuilder;
import org.apache.camel.builder.RouteBuilder;
import org.apache.camel.component.mock.MockEndpoint;
import org.apache.camel.impl.DefaultCamelContext;
import org.apache.camel.model.RouteDefinition;
import org.jboss.arquillian.container.test.api.Deployment;
import org.jboss.arquillian.junit.Arquillian;
import org.jboss.shrinkwrap.api.ShrinkWrap;
import org.jboss.shrinkwrap.api.spec.JavaArchive;
import org.junit.Assert;
import org.junit.Test;
import org.junit.runner.RunWith;
import org.wildfly.extension.camel.CamelAware;

@CamelAware
@RunWith(value=Arquillian.class)
public class JCacheProducerIntegrationTest {
    @Deployment
    public static JavaArchive createdeployment() {
        JavaArchive archive = (JavaArchive)ShrinkWrap.create(JavaArchive.class, (String)"camel-jcache-tests");
        return archive;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    public void testPutGetAndRemove() throws Exception {
        DefaultCamelContext camelctx = new DefaultCamelContext();
        camelctx.addRoutes((RoutesBuilder)new RouteBuilder(){

            public void configure() {
                ((RouteDefinition)this.from("direct:put").to("jcache://test-cache")).to("mock:put");
                ((RouteDefinition)this.from("direct:get").to("jcache://test-cache")).to("mock:get");
            }
        });
        HashMap<String, String> headers = new HashMap<String, String>();
        String key = this.randomString();
        final String val = this.randomString();
        camelctx.start();
        try {
            ProducerTemplate producer = camelctx.createProducerTemplate();
            headers.clear();
            headers.put("CamelJCacheAction", "PUT");
            headers.put("CamelJCacheKey", key);
            producer.sendBodyAndHeaders("direct:put", (Object)val, headers);
            MockEndpoint mock = (MockEndpoint)camelctx.getEndpoint("mock:put", MockEndpoint.class);
            mock.expectedMinimumMessageCount(1);
            mock.expectedHeaderReceived("CamelJCacheKey", (Object)key);
            mock.expectedMessagesMatches(new Predicate[]{new Predicate(){

                public boolean matches(Exchange exchange) {
                    Assert.assertNotNull((String)"body", (Object)exchange.getIn().getBody());
                    return exchange.getIn().getBody().equals(val);
                }
            }});
            mock.assertIsSatisfied();
            headers.clear();
            headers.put("CamelJCacheAction", "GETANDREMOVE");
            headers.put("CamelJCacheKey", key);
            producer.sendBodyAndHeaders("direct:get", null, headers);
            mock = (MockEndpoint)camelctx.getEndpoint("mock:put", MockEndpoint.class);
            mock.expectedMinimumMessageCount(1);
            mock.expectedHeaderReceived("CamelJCacheKey", (Object)key);
            mock.expectedMessagesMatches(new Predicate[]{new Predicate(){

                public boolean matches(Exchange exchange) {
                    Assert.assertNotNull((String)"body", (Object)exchange.getIn().getBody());
                    return exchange.getIn().getBody().equals(val);
                }
            }});
            mock.assertIsSatisfied();
        }
        finally {
            camelctx.stop();
        }
    }

    private String randomString() {
        return UUID.randomUUID().toString();
    }
}

