/*
 * Decompiled with CFR 0.152.
 */
package org.wildfly.camel.test.mllp.subA;

import java.text.SimpleDateFormat;
import java.util.Date;

public final class Hl7MessageGenerator {
    static SimpleDateFormat timestampFormat = new SimpleDateFormat("YYYYMMddHHmmss");
    static String messageControlIdFormat = "%05d";
    static String hl7MessageTemplate = "MSH|^~\\&|ADT|EPIC|JCAPS|CC|<MESSAGE_TIMESTAMP>|RISTECH|ADT^A08|<MESSAGE_CONTROL_ID>|D|2.3^^|||||||\rEVN|A08|20150107161440||REG_UPDATE_SEND_VISIT_MESSAGES_ON_PATIENT_CHANGES|RISTECH^RADIOLOGY^TECHNOLOGIST^^^^^^UCLA^^^^^RRMC||\rPID|1|2100355^^^MRN^MRN|2100355^^^MRN^MRN||MDCLS9^MC9||19700109|F||U|111 HOVER STREET^^LOS ANGELES^CA^90032^USA^P^^LOS ANGELE|LOS ANGELE|(310)725-6952^P^PH^^^310^7256952||ENGLISH|U||60000013647|565-33-2222|||U||||||||N||\rPD1|||UCLA HEALTH SYSTEM^^10|10002116^ADAMS^JOHN^D^^^^^EPIC^^^^PROVID||||||||||||||\rNK1|1|DOE^MC9^^|OTH|^^^^^USA|(310)888-9999^^^^^310^8889999|(310)999-2222^^^^^310^9992222|Emergency Contact 1|||||||||||||||||||||||||||\rPV1|1|OUTPATIENT|RR CT^^^1000^^^^^^^DEPID|EL|||017511^TOBIAS^JONATHAN^^^^^^EPIC^^^^PROVID|017511^TOBIAS^JONATHAN^^^^^^EPIC^^^^PROVID||||||CLR|||||60000013647|SELF|||||||||||||||||||||HOV_CONF|^^^1000^^^^^^^||20150107161438||||||||||\rPV2||||||||20150107161438||||CT BRAIN W WO CONTRAST||||||||||N|||||||||||||||||||||||||||\rZPV||||||||||||20150107161438|||||||||\rAL1|1||33361^NO KNOWN ALLERGIES^^NOTCOMPUTRITION^NO KNOWN ALLERGIES^EXTELG||||||\rDG1|1|DX|784.0^Headache^DX|Headache||VISIT\rGT1|1|1000235129|MDCLS9^MC9^^||111 HOVER STREET^^LOS ANGELES^CA^90032^USA^^^LOS ANGELE|(310)725-6952^^^^^310^7256952||19700109|F|P/F|SLF|565-33-2222|||||^^^^^USA|||UNKNOWN|||||||||||||||||||||||||||||\rUB2||||||||\r\r\n";

    private Hl7MessageGenerator() {
    }

    public static String generateMessage() {
        return Hl7MessageGenerator.generateMessage(new Date(), 1);
    }

    public static String generateMessage(int messageControlId) {
        return Hl7MessageGenerator.generateMessage(new Date(), messageControlId);
    }

    public static String generateMessage(Date timestamp, int messageControlId) {
        String tmpMessage = hl7MessageTemplate.replaceFirst("<MESSAGE_TIMESTAMP>", timestampFormat.format(timestamp));
        return tmpMessage.replaceFirst("<MESSAGE_CONTROL_ID>", String.format("%05d", messageControlId));
    }

    public static String getHl7MessageTemplate() {
        return hl7MessageTemplate;
    }

    public static void setHl7MessageTemplate(String hl7MessageTemplate) {
        Hl7MessageGenerator.hl7MessageTemplate = hl7MessageTemplate;
    }

    public static SimpleDateFormat getTimestampFormat() {
        return timestampFormat;
    }

    public static void setTimestampFormat(SimpleDateFormat timestampFormat) {
        Hl7MessageGenerator.timestampFormat = timestampFormat;
    }

    public static String getMessageControlIdFormat() {
        return messageControlIdFormat;
    }

    public static void setMessageControlIdFormat(String messageControlIdFormat) {
        Hl7MessageGenerator.messageControlIdFormat = messageControlIdFormat;
    }
}

