/*
 * Decompiled with CFR 0.152.
 */
package org.wildfly.camel.test.mqtt;

import java.io.BufferedReader;
import java.io.IOException;
import java.io.InputStreamReader;
import java.util.concurrent.TimeUnit;
import org.apache.activemq.broker.BrokerService;
import org.apache.camel.Expression;
import org.apache.camel.PollingConsumer;
import org.apache.camel.ProducerTemplate;
import org.apache.camel.RoutesBuilder;
import org.apache.camel.builder.RouteBuilder;
import org.apache.camel.impl.DefaultCamelContext;
import org.apache.camel.model.RouteDefinition;
import org.fusesource.mqtt.client.BlockingConnection;
import org.fusesource.mqtt.client.MQTT;
import org.fusesource.mqtt.client.Message;
import org.fusesource.mqtt.client.QoS;
import org.fusesource.mqtt.client.Topic;
import org.jboss.arquillian.container.test.api.Deployment;
import org.jboss.arquillian.junit.Arquillian;
import org.jboss.as.arquillian.api.ServerSetup;
import org.jboss.as.arquillian.api.ServerSetupTask;
import org.jboss.as.arquillian.container.ManagementClient;
import org.jboss.gravia.resource.ManifestBuilder;
import org.jboss.shrinkwrap.api.ShrinkWrap;
import org.jboss.shrinkwrap.api.asset.Asset;
import org.jboss.shrinkwrap.api.asset.StringAsset;
import org.jboss.shrinkwrap.api.spec.JavaArchive;
import org.junit.Assert;
import org.junit.Test;
import org.junit.runner.RunWith;
import org.wildfly.camel.test.common.utils.AvailablePortFinder;
import org.wildfly.extension.camel.CamelAware;

@CamelAware
@RunWith(value=Arquillian.class)
@ServerSetup(value={BrokerSetup.class})
public class MQTTIntegrationTest {
    @Deployment
    public static JavaArchive deployment() {
        JavaArchive archive = (JavaArchive)ShrinkWrap.create(JavaArchive.class, (String)"mqtt-tests");
        archive.addAsResource((Asset)new StringAsset(BrokerSetup.TCP_CONNECTION), "tcp-connection");
        archive.setManifest(() -> {
            ManifestBuilder builder = new ManifestBuilder();
            builder.addManifestHeader("Dependencies", "org.fusesource.mqtt");
            return builder.openStream();
        });
        return archive;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    public void testMQTTConsumer() throws Exception {
        DefaultCamelContext camelctx = new DefaultCamelContext();
        camelctx.addRoutes((RoutesBuilder)new RouteBuilder(){

            public void configure() throws Exception {
                ((RouteDefinition)this.from("mqtt:bar?subscribeTopicName=ComponentTestTopic&host=" + MQTTIntegrationTest.this.getConnection()).transform((Expression)this.body().prepend((Object)"Hello "))).to("seda:end");
            }
        });
        camelctx.start();
        PollingConsumer consumer = camelctx.getEndpoint("seda:end").createPollingConsumer();
        consumer.start();
        try {
            MQTT mqtt = new MQTT();
            mqtt.setHost(this.getConnection());
            BlockingConnection connection = mqtt.blockingConnection();
            Topic topic = new Topic("ComponentTestTopic", QoS.AT_MOST_ONCE);
            connection.connect();
            try {
                connection.publish(topic.name().toString(), "Kermit".getBytes(), QoS.AT_LEAST_ONCE, false);
            }
            finally {
                connection.disconnect();
            }
            String result = (String)consumer.receive(3000L).getIn().getBody(String.class);
            Assert.assertEquals((Object)"Hello Kermit", (Object)result);
        }
        finally {
            camelctx.stop();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    public void testMQTTProducer() throws Exception {
        DefaultCamelContext camelctx = new DefaultCamelContext();
        camelctx.addRoutes((RoutesBuilder)new RouteBuilder(){

            public void configure() throws Exception {
                ((RouteDefinition)this.from("direct:start").transform((Expression)this.body().prepend((Object)"Hello "))).to("mqtt:foo?publishTopicName=ComponentTestTopic&host=" + MQTTIntegrationTest.this.getConnection());
            }
        });
        camelctx.start();
        try {
            MQTT mqtt = new MQTT();
            mqtt.setHost(this.getConnection());
            BlockingConnection connection = mqtt.blockingConnection();
            connection.connect();
            try {
                Topic topic = new Topic("ComponentTestTopic", QoS.AT_MOST_ONCE);
                connection.subscribe(new Topic[]{topic});
                ProducerTemplate producer = camelctx.createProducerTemplate();
                producer.asyncSendBody("direct:start", (Object)"Kermit");
                Message message = connection.receive(10L, TimeUnit.SECONDS);
                message.ack();
                String result = new String(message.getPayload());
                Assert.assertEquals((Object)"Hello Kermit", (Object)result);
            }
            finally {
                connection.disconnect();
            }
        }
        finally {
            camelctx.stop();
        }
    }

    private String getConnection() throws IOException {
        try (BufferedReader br = new BufferedReader(new InputStreamReader(this.getClass().getResourceAsStream("/tcp-connection")));){
            String string = br.readLine();
            return string;
        }
    }

    static class BrokerSetup
    implements ServerSetupTask {
        static final int PORT = AvailablePortFinder.getNextAvailable();
        static final String MQTT_CONNECTION = "mqtt://127.0.0.1:" + PORT;
        static final String TCP_CONNECTION = "tcp://127.0.0.1:" + PORT;
        static final String TEST_TOPIC = "ComponentTestTopic";
        private BrokerService brokerService;

        BrokerSetup() {
        }

        public void setup(ManagementClient managementClient, String containerId) throws Exception {
            this.brokerService = new BrokerService();
            this.brokerService.setPersistent(false);
            this.brokerService.setAdvisorySupport(false);
            this.brokerService.addConnector(MQTT_CONNECTION);
            this.brokerService.start();
        }

        public void tearDown(ManagementClient managementClient, String containerId) throws Exception {
            this.brokerService.stop();
        }
    }
}

