/*
 * Decompiled with CFR 0.152.
 */
package org.wildfly.camel.test.mybatis;

import java.sql.Connection;
import java.sql.SQLException;
import java.sql.Statement;
import org.apache.camel.CamelContext;
import org.apache.camel.ProducerTemplate;
import org.apache.camel.RoutesBuilder;
import org.apache.camel.builder.RouteBuilder;
import org.apache.camel.component.mock.MockEndpoint;
import org.apache.camel.component.mybatis.MyBatisComponent;
import org.apache.camel.impl.DefaultCamelContext;
import org.apache.camel.model.RouteDefinition;
import org.jboss.arquillian.container.test.api.Deployment;
import org.jboss.arquillian.junit.Arquillian;
import org.jboss.gravia.resource.ManifestBuilder;
import org.jboss.shrinkwrap.api.ShrinkWrap;
import org.jboss.shrinkwrap.api.spec.JavaArchive;
import org.junit.Assert;
import org.junit.Test;
import org.junit.runner.RunWith;
import org.wildfly.camel.test.mybatis.subA.Account;
import org.wildfly.extension.camel.CamelAware;

@CamelAware
@RunWith(value=Arquillian.class)
public class MyBatisIntegrationTest {
    @Deployment
    public static JavaArchive createdeployment() {
        JavaArchive archive = (JavaArchive)ShrinkWrap.create(JavaArchive.class, (String)"camel-mybatis-tests");
        archive.addClasses(new Class[]{Account.class});
        archive.addAsResource("mybatis/SqlMapConfig.xml", "SqlMapConfig.xml");
        archive.addAsResource("mybatis/Account.xml");
        archive.setManifest(() -> {
            ManifestBuilder builder = new ManifestBuilder();
            builder.addManifestHeader("Dependencies", "com.h2database.h2");
            return builder.openStream();
        });
        return archive;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    public void testInsert() throws Exception {
        DefaultCamelContext camelctx = new DefaultCamelContext();
        camelctx.addRoutes((RoutesBuilder)new RouteBuilder(){

            public void configure() throws Exception {
                ((RouteDefinition)this.from("direct:start").to("mybatis:insertAccount?statementType=Insert")).to("mock:result");
            }
        });
        MockEndpoint mock = (MockEndpoint)camelctx.getEndpoint("mock:result", MockEndpoint.class);
        mock.expectedMessageCount(1);
        Account account = new Account();
        account.setId(444);
        account.setFirstName("Willem");
        account.setLastName("Jiang");
        account.setEmailAddress("Faraway@gmail.com");
        camelctx.start();
        try {
            this.createTable((CamelContext)camelctx);
            ProducerTemplate producer = camelctx.createProducerTemplate();
            producer.sendBody("direct:start", (Object)account);
            mock.assertIsSatisfied();
            Integer rows = (Integer)producer.requestBody("mybatis:count?statementType=SelectOne", null, Integer.class);
            Assert.assertEquals((long)1L, (long)rows.intValue());
        }
        finally {
            this.dropTable((CamelContext)camelctx);
            camelctx.stop();
        }
    }

    private void createTable(CamelContext camelctx) throws SQLException, Exception {
        try (Connection connection = this.createConnection(camelctx);){
            Statement statement = connection.createStatement();
            statement.execute(this.createStatement());
            connection.commit();
            statement.close();
        }
    }

    private void dropTable(CamelContext camelctx) throws SQLException, Exception {
        try (Connection connection = this.createConnection(camelctx);){
            Statement statement = connection.createStatement();
            statement.execute("drop table ACCOUNT");
            connection.commit();
            statement.close();
        }
    }

    private String createStatement() {
        return "create table ACCOUNT (ACC_ID INTEGER, ACC_FIRST_NAME VARCHAR(255), ACC_LAST_NAME VARCHAR(255), ACC_EMAIL VARCHAR(255))";
    }

    private Connection createConnection(CamelContext camelctx) throws Exception {
        MyBatisComponent component = (MyBatisComponent)camelctx.getComponent("mybatis", MyBatisComponent.class);
        return component.getSqlSessionFactory().getConfiguration().getEnvironment().getDataSource().getConnection();
    }
}

