/*
 * Decompiled with CFR 0.152.
 */
package org.wildfly.camel.test.olingo2.subA;

import java.util.ArrayList;
import java.util.List;
import org.apache.olingo.odata2.api.edm.EdmConcurrencyMode;
import org.apache.olingo.odata2.api.edm.EdmFacets;
import org.apache.olingo.odata2.api.edm.EdmMultiplicity;
import org.apache.olingo.odata2.api.edm.EdmSimpleTypeKind;
import org.apache.olingo.odata2.api.edm.FullQualifiedName;
import org.apache.olingo.odata2.api.edm.provider.Association;
import org.apache.olingo.odata2.api.edm.provider.AssociationEnd;
import org.apache.olingo.odata2.api.edm.provider.AssociationSet;
import org.apache.olingo.odata2.api.edm.provider.AssociationSetEnd;
import org.apache.olingo.odata2.api.edm.provider.ComplexProperty;
import org.apache.olingo.odata2.api.edm.provider.ComplexType;
import org.apache.olingo.odata2.api.edm.provider.CustomizableFeedMappings;
import org.apache.olingo.odata2.api.edm.provider.EdmProvider;
import org.apache.olingo.odata2.api.edm.provider.EntityContainer;
import org.apache.olingo.odata2.api.edm.provider.EntityContainerInfo;
import org.apache.olingo.odata2.api.edm.provider.EntitySet;
import org.apache.olingo.odata2.api.edm.provider.EntityType;
import org.apache.olingo.odata2.api.edm.provider.Facets;
import org.apache.olingo.odata2.api.edm.provider.FunctionImport;
import org.apache.olingo.odata2.api.edm.provider.Key;
import org.apache.olingo.odata2.api.edm.provider.NavigationProperty;
import org.apache.olingo.odata2.api.edm.provider.PropertyRef;
import org.apache.olingo.odata2.api.edm.provider.ReturnType;
import org.apache.olingo.odata2.api.edm.provider.Schema;
import org.apache.olingo.odata2.api.edm.provider.SimpleProperty;
import org.apache.olingo.odata2.api.exception.ODataException;

public class MyEdmProvider
extends EdmProvider {
    static final String ENTITY_SET_NAME_MANUFACTURERS = "Manufacturers";
    static final String ENTITY_SET_NAME_CARS = "Cars";
    static final String ENTITY_NAME_MANUFACTURER = "Manufacturer";
    static final String ENTITY_NAME_CAR = "Car";
    private static final String NAMESPACE = "org.apache.olingo.odata2.ODataCars";
    private static final FullQualifiedName ENTITY_TYPE_1_1 = new FullQualifiedName("org.apache.olingo.odata2.ODataCars", "Car");
    private static final FullQualifiedName ENTITY_TYPE_1_2 = new FullQualifiedName("org.apache.olingo.odata2.ODataCars", "Manufacturer");
    private static final FullQualifiedName COMPLEX_TYPE = new FullQualifiedName("org.apache.olingo.odata2.ODataCars", "Address");
    private static final FullQualifiedName ASSOCIATION_CAR_MANUFACTURER = new FullQualifiedName("org.apache.olingo.odata2.ODataCars", "Car_Manufacturer_Manufacturer_Cars");
    private static final String ROLE_1_1 = "Car_Manufacturer";
    private static final String ROLE_1_2 = "Manufacturer_Cars";
    private static final String ENTITY_CONTAINER = "ODataCarsEntityContainer";
    private static final String ASSOCIATION_SET = "Cars_Manufacturers";
    private static final String FUNCTION_IMPORT = "NumberOfCars";

    public List<Schema> getSchemas() throws ODataException {
        ArrayList<Schema> schemas = new ArrayList<Schema>();
        Schema schema = new Schema();
        schema.setNamespace(NAMESPACE);
        ArrayList<EntityType> entityTypes = new ArrayList<EntityType>();
        entityTypes.add(this.getEntityType(ENTITY_TYPE_1_1));
        entityTypes.add(this.getEntityType(ENTITY_TYPE_1_2));
        schema.setEntityTypes(entityTypes);
        ArrayList<ComplexType> complexTypes = new ArrayList<ComplexType>();
        complexTypes.add(this.getComplexType(COMPLEX_TYPE));
        schema.setComplexTypes(complexTypes);
        ArrayList<Association> associations = new ArrayList<Association>();
        associations.add(this.getAssociation(ASSOCIATION_CAR_MANUFACTURER));
        schema.setAssociations(associations);
        ArrayList<EntityContainer> entityContainers = new ArrayList<EntityContainer>();
        EntityContainer entityContainer = new EntityContainer();
        entityContainer.setName(ENTITY_CONTAINER).setDefaultEntityContainer(true);
        ArrayList<EntitySet> entitySets = new ArrayList<EntitySet>();
        entitySets.add(this.getEntitySet(ENTITY_CONTAINER, ENTITY_SET_NAME_CARS));
        entitySets.add(this.getEntitySet(ENTITY_CONTAINER, ENTITY_SET_NAME_MANUFACTURERS));
        entityContainer.setEntitySets(entitySets);
        ArrayList<AssociationSet> associationSets = new ArrayList<AssociationSet>();
        associationSets.add(this.getAssociationSet(ENTITY_CONTAINER, ASSOCIATION_CAR_MANUFACTURER, ENTITY_SET_NAME_MANUFACTURERS, ROLE_1_2));
        entityContainer.setAssociationSets(associationSets);
        ArrayList<FunctionImport> functionImports = new ArrayList<FunctionImport>();
        functionImports.add(this.getFunctionImport(ENTITY_CONTAINER, FUNCTION_IMPORT));
        entityContainer.setFunctionImports(functionImports);
        entityContainers.add(entityContainer);
        schema.setEntityContainers(entityContainers);
        schemas.add(schema);
        return schemas;
    }

    public EntityType getEntityType(FullQualifiedName edmFQName) throws ODataException {
        if (NAMESPACE.equals(edmFQName.getNamespace())) {
            if (ENTITY_TYPE_1_1.getName().equals(edmFQName.getName())) {
                ArrayList<SimpleProperty> properties = new ArrayList<SimpleProperty>();
                properties.add(new SimpleProperty().setName("Id").setType(EdmSimpleTypeKind.Int32).setFacets((EdmFacets)new Facets().setNullable(Boolean.valueOf(false))));
                properties.add(new SimpleProperty().setName("Model").setType(EdmSimpleTypeKind.String).setFacets((EdmFacets)new Facets().setNullable(Boolean.valueOf(false)).setMaxLength(Integer.valueOf(100)).setDefaultValue("Hugo")).setCustomizableFeedMappings(new CustomizableFeedMappings().setFcTargetPath("SyndicationTitle")));
                properties.add(new SimpleProperty().setName("ManufacturerId").setType(EdmSimpleTypeKind.Int32));
                properties.add(new SimpleProperty().setName("Price").setType(EdmSimpleTypeKind.Decimal));
                properties.add(new SimpleProperty().setName("Currency").setType(EdmSimpleTypeKind.String).setFacets((EdmFacets)new Facets().setMaxLength(Integer.valueOf(3))));
                properties.add(new SimpleProperty().setName("ModelYear").setType(EdmSimpleTypeKind.String).setFacets((EdmFacets)new Facets().setMaxLength(Integer.valueOf(4))));
                properties.add(new SimpleProperty().setName("Updated").setType(EdmSimpleTypeKind.DateTime).setFacets((EdmFacets)new Facets().setNullable(Boolean.valueOf(false)).setConcurrencyMode(EdmConcurrencyMode.Fixed)).setCustomizableFeedMappings(new CustomizableFeedMappings().setFcTargetPath("SyndicationUpdated")));
                properties.add(new SimpleProperty().setName("ImagePath").setType(EdmSimpleTypeKind.String));
                ArrayList<NavigationProperty> navigationProperties = new ArrayList<NavigationProperty>();
                navigationProperties.add(new NavigationProperty().setName(ENTITY_NAME_MANUFACTURER).setRelationship(ASSOCIATION_CAR_MANUFACTURER).setFromRole(ROLE_1_1).setToRole(ROLE_1_2));
                ArrayList<PropertyRef> keyProperties = new ArrayList<PropertyRef>();
                keyProperties.add(new PropertyRef().setName("Id"));
                Key key = new Key().setKeys(keyProperties);
                return new EntityType().setName(ENTITY_TYPE_1_1.getName()).setProperties(properties).setKey(key).setNavigationProperties(navigationProperties);
            }
            if (ENTITY_TYPE_1_2.getName().equals(edmFQName.getName())) {
                ArrayList<Object> properties = new ArrayList<Object>();
                properties.add(new SimpleProperty().setName("Id").setType(EdmSimpleTypeKind.Int32).setFacets((EdmFacets)new Facets().setNullable(Boolean.valueOf(false))));
                properties.add(new SimpleProperty().setName("Name").setType(EdmSimpleTypeKind.String).setFacets((EdmFacets)new Facets().setNullable(Boolean.valueOf(false)).setMaxLength(Integer.valueOf(100))).setCustomizableFeedMappings(new CustomizableFeedMappings().setFcTargetPath("SyndicationTitle")));
                properties.add(new ComplexProperty().setName("Address").setType(new FullQualifiedName(NAMESPACE, "Address")));
                properties.add(new SimpleProperty().setName("Updated").setType(EdmSimpleTypeKind.DateTime).setFacets((EdmFacets)new Facets().setNullable(Boolean.valueOf(false)).setConcurrencyMode(EdmConcurrencyMode.Fixed)).setCustomizableFeedMappings(new CustomizableFeedMappings().setFcTargetPath("SyndicationUpdated")));
                ArrayList<NavigationProperty> navigationProperties = new ArrayList<NavigationProperty>();
                navigationProperties.add(new NavigationProperty().setName(ENTITY_SET_NAME_CARS).setRelationship(ASSOCIATION_CAR_MANUFACTURER).setFromRole(ROLE_1_2).setToRole(ROLE_1_1));
                ArrayList<PropertyRef> keyProperties = new ArrayList<PropertyRef>();
                keyProperties.add(new PropertyRef().setName("Id"));
                Key key = new Key().setKeys(keyProperties);
                return new EntityType().setName(ENTITY_TYPE_1_2.getName()).setProperties(properties).setKey(key).setNavigationProperties(navigationProperties);
            }
        }
        return null;
    }

    public ComplexType getComplexType(FullQualifiedName edmFQName) throws ODataException {
        if (NAMESPACE.equals(edmFQName.getNamespace()) && COMPLEX_TYPE.getName().equals(edmFQName.getName())) {
            ArrayList<SimpleProperty> properties = new ArrayList<SimpleProperty>();
            properties.add(new SimpleProperty().setName("Street").setType(EdmSimpleTypeKind.String));
            properties.add(new SimpleProperty().setName("City").setType(EdmSimpleTypeKind.String));
            properties.add(new SimpleProperty().setName("ZipCode").setType(EdmSimpleTypeKind.String));
            properties.add(new SimpleProperty().setName("Country").setType(EdmSimpleTypeKind.String));
            return new ComplexType().setName(COMPLEX_TYPE.getName()).setProperties(properties);
        }
        return null;
    }

    public Association getAssociation(FullQualifiedName edmFQName) throws ODataException {
        if (NAMESPACE.equals(edmFQName.getNamespace()) && ASSOCIATION_CAR_MANUFACTURER.getName().equals(edmFQName.getName())) {
            return new Association().setName(ASSOCIATION_CAR_MANUFACTURER.getName()).setEnd1(new AssociationEnd().setType(ENTITY_TYPE_1_1).setRole(ROLE_1_1).setMultiplicity(EdmMultiplicity.MANY)).setEnd2(new AssociationEnd().setType(ENTITY_TYPE_1_2).setRole(ROLE_1_2).setMultiplicity(EdmMultiplicity.ONE));
        }
        return null;
    }

    public EntitySet getEntitySet(String entityContainer, String name) throws ODataException {
        if (ENTITY_CONTAINER.equals(entityContainer)) {
            if (ENTITY_SET_NAME_CARS.equals(name)) {
                return new EntitySet().setName(name).setEntityType(ENTITY_TYPE_1_1);
            }
            if (ENTITY_SET_NAME_MANUFACTURERS.equals(name)) {
                return new EntitySet().setName(name).setEntityType(ENTITY_TYPE_1_2);
            }
        }
        return null;
    }

    public AssociationSet getAssociationSet(String entityContainer, FullQualifiedName association, String sourceEntitySetName, String sourceEntitySetRole) throws ODataException {
        if (ENTITY_CONTAINER.equals(entityContainer) && ASSOCIATION_CAR_MANUFACTURER.equals((Object)association)) {
            return new AssociationSet().setName(ASSOCIATION_SET).setAssociation(ASSOCIATION_CAR_MANUFACTURER).setEnd1(new AssociationSetEnd().setRole(ROLE_1_2).setEntitySet(ENTITY_SET_NAME_MANUFACTURERS)).setEnd2(new AssociationSetEnd().setRole(ROLE_1_1).setEntitySet(ENTITY_SET_NAME_CARS));
        }
        return null;
    }

    public FunctionImport getFunctionImport(String entityContainer, String name) throws ODataException {
        if (ENTITY_CONTAINER.equals(entityContainer) && FUNCTION_IMPORT.equals(name)) {
            return new FunctionImport().setName(name).setReturnType(new ReturnType().setTypeName(ENTITY_TYPE_1_1).setMultiplicity(EdmMultiplicity.MANY)).setHttpMethod("GET");
        }
        return null;
    }

    public EntityContainerInfo getEntityContainerInfo(String name) throws ODataException {
        if (name == null || ENTITY_CONTAINER.equals(name)) {
            return new EntityContainerInfo().setName(ENTITY_CONTAINER).setDefaultEntityContainer(true);
        }
        return null;
    }
}

