/*
 * Decompiled with CFR 0.152.
 */
package org.wildfly.camel.test.optaplanner;

import org.apache.camel.ProducerTemplate;
import org.apache.camel.RoutesBuilder;
import org.apache.camel.builder.RouteBuilder;
import org.apache.camel.impl.DefaultCamelContext;
import org.apache.camel.model.RouteDefinition;
import org.jboss.arquillian.container.test.api.Deployment;
import org.jboss.arquillian.junit.Arquillian;
import org.jboss.gravia.resource.ManifestBuilder;
import org.jboss.shrinkwrap.api.ShrinkWrap;
import org.jboss.shrinkwrap.api.spec.JavaArchive;
import org.junit.Assert;
import org.junit.Ignore;
import org.junit.Test;
import org.junit.runner.RunWith;
import org.optaplanner.examples.cloudbalancing.domain.CloudBalance;
import org.optaplanner.examples.cloudbalancing.domain.CloudProcess;
import org.optaplanner.examples.cloudbalancing.persistence.CloudBalancingGenerator;
import org.wildfly.extension.camel.CamelAware;

@CamelAware
@RunWith(value=Arquillian.class)
@Ignore(value="[ENTESB-6532] Cannot compile optaplanner rules on EAP-7.1")
public class OptaPlannerIntegrationTest {
    @Deployment
    public static JavaArchive createDeployment() {
        JavaArchive archive = (JavaArchive)ShrinkWrap.create(JavaArchive.class, (String)"camel-optaplanner-tests");
        archive.addPackages(true, new String[]{"org.optaplanner.examples.common.app"});
        archive.addPackages(true, new String[]{"org.optaplanner.examples.common.domain"});
        archive.addPackages(true, new String[]{"org.optaplanner.examples.common.persistence"});
        archive.addPackages(true, new String[]{"org.optaplanner.examples.common.swingui"});
        archive.addPackages(true, new String[]{"org.optaplanner.examples.cloudbalancing"});
        archive.setManifest(() -> {
            ManifestBuilder builder = new ManifestBuilder();
            builder.addManifestHeader("Dependencies", "com.google.guava,org.apache.commons.lang3");
            return builder.openStream();
        });
        archive.addAsResource("optaplanner/cloudBalancingScoreRules.drl");
        archive.addAsResource("optaplanner/solverConfig.xml");
        return archive;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    public void testSynchronousProblemSolving() throws Exception {
        CloudBalancingGenerator generator = new CloudBalancingGenerator(true);
        CloudBalance planningProblem = generator.createCloudBalance(4, 12);
        Assert.assertNull((Object)planningProblem.getScore());
        Assert.assertNull((Object)((CloudProcess)planningProblem.getProcessList().get(0)).getComputer());
        DefaultCamelContext camelctx = new DefaultCamelContext();
        camelctx.addRoutes((RoutesBuilder)new RouteBuilder(){

            public void configure() {
                this.from("direct:in").to("optaplanner:optaplanner/solverConfig.xml");
                ((RouteDefinition)this.from("optaplanner:optaplanner/solverConfig.xml").to("log:com.mycompany.order?showAll=true&multiline=true")).to("mock:result");
            }
        });
        camelctx.start();
        try {
            ProducerTemplate template = camelctx.createProducerTemplate();
            CloudBalance bestSolution = (CloudBalance)template.requestBody("direct:in", (Object)planningProblem);
            Assert.assertEquals((long)4L, (long)bestSolution.getComputerList().size());
            Assert.assertEquals((long)12L, (long)bestSolution.getProcessList().size());
            Assert.assertNotNull((Object)bestSolution.getScore());
            Assert.assertTrue((boolean)bestSolution.getScore().isFeasible());
            Assert.assertNotNull((Object)((CloudProcess)bestSolution.getProcessList().get(0)).getComputer());
        }
        finally {
            camelctx.stop();
        }
    }
}

