/*
 * Decompiled with CFR 0.152.
 */
package org.wildfly.camel.test.quartz2;

import org.apache.camel.CamelContext;
import org.apache.camel.component.mock.MockEndpoint;
import org.jboss.arquillian.container.test.api.Deployment;
import org.jboss.arquillian.junit.Arquillian;
import org.jboss.arquillian.test.api.ArquillianResource;
import org.jboss.shrinkwrap.api.ShrinkWrap;
import org.jboss.shrinkwrap.api.spec.JavaArchive;
import org.junit.Assert;
import org.junit.Test;
import org.junit.runner.RunWith;
import org.wildfly.extension.camel.CamelAware;
import org.wildfly.extension.camel.CamelContextRegistry;

@CamelAware
@RunWith(value=Arquillian.class)
public class QuartzPersistentStoreTest {
    @ArquillianResource
    CamelContextRegistry contextRegistry;

    @Deployment
    public static JavaArchive deployment() {
        JavaArchive archive = (JavaArchive)ShrinkWrap.create(JavaArchive.class, (String)"quartz-tests");
        archive.addAsManifestResource("quartz/quartz-camel-context.xml");
        archive.addAsResource("quartz/sql/db-schema.sql", "db-schema.sql");
        return archive;
    }

    @Test
    public void restartRouteTest() throws Exception {
        CamelContext camelctx = this.contextRegistry.getCamelContext("quartz-context");
        Assert.assertNotNull((Object)camelctx);
        MockEndpoint mockEndpoint = (MockEndpoint)camelctx.getEndpoint("mock:result", MockEndpoint.class);
        mockEndpoint.expectedMinimumMessageCount(2);
        mockEndpoint.assertIsSatisfied();
        camelctx.stopRoute("myRoute");
        mockEndpoint.reset();
        mockEndpoint.expectedMessageCount(0);
        Thread.sleep(2000L);
        mockEndpoint.assertIsSatisfied();
        mockEndpoint.reset();
        mockEndpoint.expectedMinimumMessageCount(2);
        camelctx.startRoute("myRoute");
        mockEndpoint.assertIsSatisfied();
    }
}

