/*
 * Decompiled with CFR 0.152.
 */
package org.wildfly.camel.test.sjms;

import java.util.ArrayList;
import java.util.concurrent.CountDownLatch;
import java.util.concurrent.TimeUnit;
import javax.jms.Connection;
import javax.jms.ConnectionFactory;
import javax.jms.Destination;
import javax.jms.JMSException;
import javax.jms.Message;
import javax.jms.MessageConsumer;
import javax.jms.MessageListener;
import javax.jms.MessageProducer;
import javax.jms.Session;
import javax.jms.TextMessage;
import javax.naming.InitialContext;
import org.apache.camel.Expression;
import org.apache.camel.PollingConsumer;
import org.apache.camel.ProducerTemplate;
import org.apache.camel.RoutesBuilder;
import org.apache.camel.builder.RouteBuilder;
import org.apache.camel.impl.DefaultCamelContext;
import org.apache.camel.model.RouteDefinition;
import org.jboss.arquillian.container.test.api.Deployment;
import org.jboss.arquillian.junit.Arquillian;
import org.jboss.arquillian.test.api.ArquillianResource;
import org.jboss.as.arquillian.api.ServerSetup;
import org.jboss.as.arquillian.api.ServerSetupTask;
import org.jboss.as.arquillian.container.ManagementClient;
import org.jboss.as.controller.client.ModelControllerClient;
import org.jboss.shrinkwrap.api.ShrinkWrap;
import org.jboss.shrinkwrap.api.spec.JavaArchive;
import org.junit.Assert;
import org.junit.Test;
import org.junit.runner.RunWith;
import org.wildfly.camel.test.common.utils.JMSUtils;
import org.wildfly.extension.camel.CamelAware;

@CamelAware
@RunWith(value=Arquillian.class)
@ServerSetup(value={JmsQueueSetup.class})
public class SJMSIntegrationTest {
    static final String QUEUE_NAME = "sjms-queue";
    static final String QUEUE_JNDI_NAME = "java:/sjms-queue";
    @ArquillianResource
    InitialContext initialctx;

    @Deployment
    public static JavaArchive createdeployment() {
        return (JavaArchive)ShrinkWrap.create(JavaArchive.class, (String)"camel-jms-tests");
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    public void testMessageConsumerRoute() throws Exception {
        DefaultCamelContext camelctx = new DefaultCamelContext();
        camelctx.addRoutes((RoutesBuilder)new RouteBuilder(){

            public void configure() throws Exception {
                ((RouteDefinition)this.from("sjms:queue:sjms-queue?connectionFactory=ConnectionFactory").transform((Expression)this.body().prepend((Object)"Hello "))).to("seda:end");
            }
        });
        camelctx.start();
        PollingConsumer consumer = camelctx.getEndpoint("seda:end").createPollingConsumer();
        consumer.start();
        try {
            ConnectionFactory cfactory = (ConnectionFactory)this.initialctx.lookup("java:/ConnectionFactory");
            try (Connection connection = cfactory.createConnection();){
                this.sendMessage(connection, QUEUE_JNDI_NAME, "Kermit");
                String result = (String)consumer.receive(3000L).getIn().getBody(String.class);
                Assert.assertEquals((Object)"Hello Kermit", (Object)result);
            }
        }
        finally {
            camelctx.stop();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    public void testMessageProviderRoute() throws Exception {
        DefaultCamelContext camelctx = new DefaultCamelContext();
        camelctx.addRoutes((RoutesBuilder)new RouteBuilder(){

            public void configure() throws Exception {
                ((RouteDefinition)this.from("direct:start").transform((Expression)this.body().prepend((Object)"Hello "))).to("sjms:queue:sjms-queue?connectionFactory=ConnectionFactory");
            }
        });
        final ArrayList result = new ArrayList();
        final CountDownLatch latch = new CountDownLatch(1);
        camelctx.start();
        try {
            ConnectionFactory cfactory = (ConnectionFactory)this.initialctx.lookup("java:/ConnectionFactory");
            try (Connection connection = cfactory.createConnection();){
                this.receiveMessage(connection, QUEUE_JNDI_NAME, new MessageListener(){

                    public void onMessage(Message message) {
                        TextMessage text = (TextMessage)message;
                        try {
                            result.add(text.getText());
                        }
                        catch (JMSException ex) {
                            result.add(ex.getMessage());
                        }
                        latch.countDown();
                    }
                });
                ProducerTemplate producer = camelctx.createProducerTemplate();
                producer.asyncSendBody("direct:start", (Object)"Kermit");
                Assert.assertTrue((boolean)latch.await(10L, TimeUnit.SECONDS));
                Assert.assertEquals((String)"One message", (long)1L, (long)result.size());
                Assert.assertEquals((Object)"Hello Kermit", result.get(0));
            }
        }
        finally {
            camelctx.stop();
        }
    }

    private void sendMessage(Connection connection, String jndiName, String message) throws Exception {
        Session session = connection.createSession(false, 1);
        Destination destination = (Destination)this.initialctx.lookup(jndiName);
        MessageProducer producer = session.createProducer(destination);
        TextMessage msg = session.createTextMessage(message);
        producer.send((Message)msg);
        connection.start();
    }

    private Session receiveMessage(Connection connection, String jndiName, MessageListener listener) throws Exception {
        Session session = connection.createSession(false, 1);
        Destination destination = (Destination)this.initialctx.lookup(jndiName);
        MessageConsumer consumer = session.createConsumer(destination);
        consumer.setMessageListener(listener);
        connection.start();
        return session;
    }

    static class JmsQueueSetup
    implements ServerSetupTask {
        JmsQueueSetup() {
        }

        public void setup(ManagementClient managementClient, String containerId) throws Exception {
            JMSUtils.createJmsQueue((String)SJMSIntegrationTest.QUEUE_NAME, (String)SJMSIntegrationTest.QUEUE_JNDI_NAME, (ModelControllerClient)managementClient.getControllerClient());
        }

        public void tearDown(ManagementClient managementClient, String containerId) throws Exception {
            JMSUtils.removeJmsQueue((String)SJMSIntegrationTest.QUEUE_NAME, (ModelControllerClient)managementClient.getControllerClient());
        }
    }
}

