/*
 * Decompiled with CFR 0.152.
 */
package org.wildfly.camel.test.sshd;

import java.nio.file.Path;
import java.nio.file.Paths;
import org.apache.camel.ProducerTemplate;
import org.apache.camel.RoutesBuilder;
import org.apache.camel.builder.RouteBuilder;
import org.apache.camel.component.mock.MockEndpoint;
import org.apache.camel.impl.DefaultCamelContext;
import org.jboss.arquillian.container.test.api.Deployment;
import org.jboss.arquillian.junit.Arquillian;
import org.jboss.gravia.resource.ManifestBuilder;
import org.jboss.shrinkwrap.api.ShrinkWrap;
import org.jboss.shrinkwrap.api.spec.JavaArchive;
import org.junit.After;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Ignore;
import org.junit.Test;
import org.junit.runner.RunWith;
import org.wildfly.camel.test.common.ssh.EmbeddedSSHServer;
import org.wildfly.camel.test.common.utils.AvailablePortFinder;
import org.wildfly.camel.test.common.utils.EnvironmentUtils;
import org.wildfly.extension.camel.CamelAware;

@CamelAware
@RunWith(value=Arquillian.class)
public class SSHIntegrationTest {
    private static final Path SSHD_ROOT_DIR = Paths.get("target/sshd", new String[0]);
    private EmbeddedSSHServer sshServer;

    @Deployment
    public static JavaArchive createDeployment() {
        return (JavaArchive)((JavaArchive)((JavaArchive)ShrinkWrap.create(JavaArchive.class, (String)"sshd-tests.jar")).addClasses(new Class[]{EmbeddedSSHServer.class, AvailablePortFinder.class, EnvironmentUtils.class})).setManifest(() -> {
            ManifestBuilder builder = new ManifestBuilder();
            builder.addManifestHeader("Dependencies", "com.jcraft.jsch,org.apache.sshd");
            return builder.openStream();
        });
    }

    @Before
    public void setUp() throws Exception {
        this.sshServer = new EmbeddedSSHServer(SSHD_ROOT_DIR, AvailablePortFinder.getNextAvailable());
        this.sshServer.start();
    }

    @After
    public void tearDown() throws Exception {
        if (this.sshServer != null) {
            this.sshServer.stop();
        }
    }

    @Test
    public void testSSHConsumer() throws Exception {
        DefaultCamelContext camelctx = new DefaultCamelContext();
        camelctx.addRoutes((RoutesBuilder)new RouteBuilder(){

            public void configure() throws Exception {
                this.from("ssh://admin@" + SSHIntegrationTest.this.sshServer.getConnection() + "?username=admin&password=admin&pollCommand=echo Hello Kermit").to("mock:end");
            }
        });
        camelctx.start();
        try {
            MockEndpoint mockEndpoint = (MockEndpoint)camelctx.getEndpoint("mock:end", MockEndpoint.class);
            mockEndpoint.expectedMessageCount(1);
            mockEndpoint.setAssertPeriod(100L);
            mockEndpoint.expectedBodiesReceived(new Object[]{"Hello Kermit" + System.lineSeparator()});
        }
        finally {
            camelctx.stop();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    @Ignore(value="[#1564] SSH producer test frequently swallows the output")
    public void testSSHProducer() throws Exception {
        DefaultCamelContext camelctx = new DefaultCamelContext();
        camelctx.addRoutes((RoutesBuilder)new RouteBuilder(){

            public void configure() throws Exception {
                this.from("direct:start").to("ssh://admin@" + SSHIntegrationTest.this.sshServer.getConnection() + "?username=admin&password=admin");
            }
        });
        camelctx.start();
        try {
            ProducerTemplate template = camelctx.createProducerTemplate();
            String result = (String)template.requestBody("direct:start", (Object)"echo Hello Kermit", String.class);
            Assert.assertEquals((Object)("Hello Kermit" + System.lineSeparator()), (Object)result);
        }
        finally {
            camelctx.stop();
        }
    }
}

