/*
 * Decompiled with CFR 0.152.
 */
package org.wildfly.camel.test.yaml;

import org.apache.camel.ProducerTemplate;
import org.apache.camel.RoutesBuilder;
import org.apache.camel.builder.RouteBuilder;
import org.apache.camel.component.snakeyaml.SnakeYAMLDataFormat;
import org.apache.camel.component.snakeyaml.TypeFilter;
import org.apache.camel.component.snakeyaml.TypeFilters;
import org.apache.camel.impl.DefaultCamelContext;
import org.apache.camel.model.dataformat.YAMLLibrary;
import org.apache.camel.spi.DataFormat;
import org.jboss.arquillian.container.test.api.Deployment;
import org.jboss.arquillian.junit.Arquillian;
import org.jboss.shrinkwrap.api.ShrinkWrap;
import org.jboss.shrinkwrap.api.spec.JavaArchive;
import org.junit.Assert;
import org.junit.Test;
import org.junit.runner.RunWith;
import org.wildfly.camel.test.common.types.Customer;
import org.wildfly.extension.camel.CamelAware;

@CamelAware
@RunWith(value=Arquillian.class)
public class YamlDataFormatIntegrationTest {
    public static final String CUSTOMER_YAML = "!!org.wildfly.camel.test.common.types.Customer {firstName: John, lastName: Doe}";

    @Deployment
    public static JavaArchive createDeployment() {
        return (JavaArchive)((JavaArchive)ShrinkWrap.create(JavaArchive.class, (String)"camel-yaml-tests")).addClass(Customer.class);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    public void testMarshalYaml() throws Exception {
        DefaultCamelContext camelctx = new DefaultCamelContext();
        camelctx.addRoutes((RoutesBuilder)new RouteBuilder(){

            public void configure() throws Exception {
                this.from("direct:start").marshal().yaml(YAMLLibrary.SnakeYAML);
            }
        });
        camelctx.start();
        try {
            ProducerTemplate template = camelctx.createProducerTemplate();
            String result = (String)template.requestBody("direct:start", (Object)new Customer("John", "Doe"), String.class);
            Assert.assertEquals((Object)CUSTOMER_YAML, (Object)result.trim());
        }
        finally {
            camelctx.stop();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    public void testUnmarshalYaml() throws Exception {
        final SnakeYAMLDataFormat yaml = new SnakeYAMLDataFormat();
        yaml.addTypeFilters(new TypeFilter[]{TypeFilters.types((Class[])new Class[]{Customer.class})});
        DefaultCamelContext camelctx = new DefaultCamelContext();
        camelctx.addRoutes((RoutesBuilder)new RouteBuilder(){

            public void configure() throws Exception {
                this.from("direct:start").unmarshal((DataFormat)yaml);
            }
        });
        camelctx.start();
        try {
            ProducerTemplate template = camelctx.createProducerTemplate();
            Customer result = (Customer)template.requestBody("direct:start", (Object)CUSTOMER_YAML, Customer.class);
            Assert.assertNotNull((Object)result);
            Assert.assertEquals((Object)"John", (Object)result.getFirstName());
            Assert.assertEquals((Object)"Doe", (Object)result.getLastName());
        }
        finally {
            camelctx.stop();
        }
    }
}

