/*
 * Decompiled with CFR 0.152.
 */
package org.wildfly.camel.test.avro;

import java.io.IOException;
import java.io.InputStream;
import org.apache.avro.Schema;
import org.apache.avro.generic.GenericData;
import org.apache.avro.generic.GenericRecord;
import org.apache.camel.ProducerTemplate;
import org.apache.camel.RoutesBuilder;
import org.apache.camel.builder.RouteBuilder;
import org.apache.camel.dataformat.avro.AvroDataFormat;
import org.apache.camel.impl.DefaultCamelContext;
import org.apache.camel.model.RouteDefinition;
import org.apache.camel.spi.DataFormat;
import org.jboss.arquillian.container.test.api.Deployment;
import org.jboss.arquillian.junit.Arquillian;
import org.jboss.shrinkwrap.api.ShrinkWrap;
import org.jboss.shrinkwrap.api.spec.JavaArchive;
import org.junit.Assert;
import org.junit.Test;
import org.junit.runner.RunWith;
import org.wildfly.extension.camel.CamelAware;

@CamelAware
@RunWith(value=Arquillian.class)
public class AvroDataFormatTest {
    @Deployment
    public static JavaArchive createdeployment() {
        JavaArchive archive = (JavaArchive)ShrinkWrap.create(JavaArchive.class, (String)"camel-avro-tests");
        archive.addAsResource("avro/user.avsc");
        return archive;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    public void testMarshalUnmarshal() throws Exception {
        AvroDataFormat avro = new AvroDataFormat(this.getSchema());
        GenericData.Record input = new GenericData.Record(this.getSchema());
        input.put("name", (Object)"Kermit");
        DefaultCamelContext camelctx = new DefaultCamelContext();
        camelctx.addRoutes((RoutesBuilder)new RouteBuilder((DataFormat)avro){
            final /* synthetic */ DataFormat val$avro;
            {
                this.val$avro = dataFormat;
            }

            public void configure() throws Exception {
                ((RouteDefinition)this.from("direct:start").marshal(this.val$avro)).unmarshal(this.val$avro);
            }
        });
        camelctx.start();
        try {
            ProducerTemplate producer = camelctx.createProducerTemplate();
            GenericRecord result = (GenericRecord)producer.requestBody("direct:start", (Object)input, GenericRecord.class);
            Assert.assertEquals((Object)"Kermit", (Object)result.get("name").toString());
        }
        finally {
            camelctx.stop();
        }
    }

    private Schema getSchema() throws IOException {
        try (InputStream input = this.getClass().getResourceAsStream("/avro/user.avsc");){
            Schema schema = new Schema.Parser().parse(input);
            return schema;
        }
    }
}

