/*
 * Decompiled with CFR 0.152.
 */
package org.wildfly.camel.test.classloading;

import org.jboss.arquillian.container.test.api.Deployment;
import org.jboss.arquillian.junit.Arquillian;
import org.jboss.modules.ModuleClassLoader;
import org.jboss.shrinkwrap.api.ShrinkWrap;
import org.jboss.shrinkwrap.api.spec.JavaArchive;
import org.junit.After;
import org.junit.AfterClass;
import org.junit.Assert;
import org.junit.Before;
import org.junit.BeforeClass;
import org.junit.Test;
import org.junit.runner.RunWith;

@RunWith(value=Arquillian.class)
public class ThreadContextClassloaderTest {
    @Deployment
    public static JavaArchive deployment() {
        return (JavaArchive)ShrinkWrap.create(JavaArchive.class, (String)"tccl-tests");
    }

    @BeforeClass
    public static void beforeClass() throws Exception {
        ThreadContextClassloaderTest.assertNoTCCL();
    }

    @AfterClass
    public static void afterClass() throws Exception {
        ThreadContextClassloaderTest.assertNoTCCL();
    }

    @Before
    public void before() throws Exception {
        ThreadContextClassloaderTest.assertModuleTCCL();
    }

    @After
    public void after() throws Exception {
        ThreadContextClassloaderTest.assertModuleTCCL();
    }

    @Test
    public void testClassLoader() throws Exception {
        ThreadContextClassloaderTest.assertModuleTCCL();
    }

    private static void assertModuleTCCL() {
        ClassLoader tccl = Thread.currentThread().getContextClassLoader();
        Assert.assertTrue((String)"TCCL is ModuleClassLoader", (boolean)(tccl instanceof ModuleClassLoader));
    }

    private static void assertNoTCCL() {
        ClassLoader tccl = Thread.currentThread().getContextClassLoader();
        if (tccl instanceof ModuleClassLoader) {
            Assert.assertNull((String)"TCCL is null", (Object)tccl);
        }
    }
}

