/*
 * Decompiled with CFR 0.152.
 */
package org.wildfly.camel.test.ejb;

import javax.naming.InitialContext;
import org.apache.camel.CamelContext;
import org.apache.camel.ProducerTemplate;
import org.apache.camel.ServiceStatus;
import org.jboss.arquillian.container.test.api.Deployer;
import org.jboss.arquillian.container.test.api.Deployment;
import org.jboss.arquillian.junit.Arquillian;
import org.jboss.arquillian.test.api.ArquillianResource;
import org.jboss.shrinkwrap.api.Archive;
import org.jboss.shrinkwrap.api.ShrinkWrap;
import org.jboss.shrinkwrap.api.spec.EnterpriseArchive;
import org.jboss.shrinkwrap.api.spec.JavaArchive;
import org.junit.Assert;
import org.junit.Test;
import org.junit.runner.RunWith;
import org.wildfly.camel.test.ejb.subA.HelloBean;
import org.wildfly.extension.camel.CamelAware;
import org.wildfly.extension.camel.CamelContextRegistry;

@CamelAware
@RunWith(value=Arquillian.class)
public class EjbEarIntegrationTest {
    static final String SIMPLE_JAR = "camel-ejb-jar.jar";
    static final String SIMPLE_EAR = "camel-ejb-ear.ear";
    @ArquillianResource
    Deployer deployer;
    @ArquillianResource
    CamelContextRegistry contextRegistry;

    @Deployment
    public static JavaArchive createdeployment() {
        return (JavaArchive)ShrinkWrap.create(JavaArchive.class, (String)"camel-ejb-ear-tests");
    }

    @Test
    public void testEjbJarDeployment() throws Exception {
        CamelContext camelctx = this.contextRegistry.getCamelContext("ejb-jar-context");
        Assert.assertEquals((Object)ServiceStatus.Started, (Object)camelctx.getStatus());
        this.assertContextAccess(camelctx);
    }

    @Test
    public void testEjbJarContextLookup() throws Exception {
        InitialContext inicxt = new InitialContext();
        CamelContext camelctx = (CamelContext)inicxt.lookup("java:jboss/camel/context/ejb-jar-context");
        Assert.assertEquals((Object)ServiceStatus.Started, (Object)camelctx.getStatus());
        this.assertContextAccess(camelctx);
    }

    @Test
    public void testEjbEarDeployment() throws Exception {
        CamelContext camelctx = this.contextRegistry.getCamelContext("ejb-ear-context");
        Assert.assertEquals((Object)ServiceStatus.Started, (Object)camelctx.getStatus());
        this.assertContextAccess(camelctx);
    }

    @Test
    public void testEjbEarContextLookup() throws Exception {
        InitialContext inicxt = new InitialContext();
        CamelContext camelctx = (CamelContext)inicxt.lookup("java:jboss/camel/context/ejb-ear-context");
        Assert.assertEquals((Object)ServiceStatus.Started, (Object)camelctx.getStatus());
        this.assertContextAccess(camelctx);
    }

    private void assertContextAccess(CamelContext camelctx) {
        ProducerTemplate producer = camelctx.createProducerTemplate();
        String result = (String)producer.requestBody("direct:start", (Object)"Kermit", String.class);
        Assert.assertEquals((Object)"Hello Kermit", (Object)result);
    }

    @Deployment(name="camel-ejb-jar.jar", managed=true, testable=false)
    public static JavaArchive createJarDeployment() {
        return EjbEarIntegrationTest.getEjbModule("ejb/ejb-jar-camel-context.xml");
    }

    @Deployment(name="camel-ejb-ear.ear", managed=true, testable=false)
    public static EnterpriseArchive createEarDeployment() {
        EnterpriseArchive ear = (EnterpriseArchive)ShrinkWrap.create(EnterpriseArchive.class, (String)SIMPLE_EAR);
        ear.addAsModule((Archive)EjbEarIntegrationTest.getEjbModule("ejb/ejb-ear-camel-context.xml"));
        return ear;
    }

    private static JavaArchive getEjbModule(String descriptorName) {
        JavaArchive jar = (JavaArchive)ShrinkWrap.create(JavaArchive.class, (String)SIMPLE_JAR);
        jar.addAsManifestResource(descriptorName, "ejb-camel-context.xml");
        jar.addClasses(new Class[]{HelloBean.class});
        return jar;
    }
}

