/*
 * Decompiled with CFR 0.152.
 */
package org.wildfly.camel.test.elasticsearch;

import java.io.IOException;
import java.nio.file.FileVisitResult;
import java.nio.file.FileVisitor;
import java.nio.file.Files;
import java.nio.file.Path;
import java.nio.file.SimpleFileVisitor;
import java.nio.file.attribute.BasicFileAttributes;
import java.util.HashMap;
import javax.inject.Inject;
import org.apache.camel.ProducerTemplate;
import org.apache.camel.RoutesBuilder;
import org.apache.camel.builder.RouteBuilder;
import org.apache.camel.component.elasticsearch.ElasticsearchComponent;
import org.apache.camel.impl.DefaultCamelContext;
import org.elasticsearch.action.delete.DeleteResponse;
import org.elasticsearch.action.get.GetResponse;
import org.elasticsearch.action.search.SearchResponse;
import org.elasticsearch.client.Client;
import org.jboss.arquillian.container.test.api.Deployment;
import org.jboss.arquillian.junit.Arquillian;
import org.jboss.shrinkwrap.api.ShrinkWrap;
import org.jboss.shrinkwrap.api.asset.Asset;
import org.jboss.shrinkwrap.api.asset.EmptyAsset;
import org.jboss.shrinkwrap.api.spec.JavaArchive;
import org.junit.Assert;
import org.junit.BeforeClass;
import org.junit.Test;
import org.junit.runner.RunWith;
import org.wildfly.camel.test.elasticsearch.subA.ElasticSearchClientProducer;
import org.wildfly.extension.camel.CamelAware;

@CamelAware
@RunWith(value=Arquillian.class)
public class ElasticSearchIntegrationTest {
    @Inject
    private Client client;

    @Deployment
    public static JavaArchive createDeployment() {
        return (JavaArchive)((JavaArchive)((JavaArchive)ShrinkWrap.create(JavaArchive.class, (String)"camel-elasticsearch-tests.jar")).addClass(ElasticSearchClientProducer.class)).addAsManifestResource((Asset)EmptyAsset.INSTANCE, "beans.xml");
    }

    @BeforeClass
    public static void beforeClass() throws IOException {
        ElasticSearchIntegrationTest.deleteDataDirectory();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    public void testIndexContentUsingHeaders() throws Exception {
        DefaultCamelContext camelctx = new DefaultCamelContext();
        camelctx.addRoutes((RoutesBuilder)new RouteBuilder(){

            public void configure() throws Exception {
                this.from("direct:start").to("elasticsearch://local");
            }
        });
        ((ElasticsearchComponent)camelctx.getComponent("elasticsearch", ElasticsearchComponent.class)).setClient(this.client);
        camelctx.start();
        try {
            HashMap<String, String> indexedData = new HashMap<String, String>();
            indexedData.put("content", "test");
            HashMap<String, String> headers = new HashMap<String, String>();
            headers.put("operation", "INDEX");
            headers.put("indexName", "twitter");
            headers.put("indexType", "tweet");
            ProducerTemplate template = camelctx.createProducerTemplate();
            String indexId = (String)template.requestBodyAndHeaders("direct:start", indexedData, headers, String.class);
            Assert.assertNotNull((String)"Index id should not be null", (Object)indexId);
        }
        finally {
            camelctx.stop();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    public void testGetContent() throws Exception {
        DefaultCamelContext camelctx = new DefaultCamelContext();
        camelctx.addRoutes((RoutesBuilder)new RouteBuilder(){

            public void configure() throws Exception {
                this.from("direct:index").to("elasticsearch://local?operation=INDEX&indexName=twitter&indexType=tweet");
                this.from("direct:get").to("elasticsearch://local?operation=GET_BY_ID&indexName=twitter&indexType=tweet");
            }
        });
        ((ElasticsearchComponent)camelctx.getComponent("elasticsearch", ElasticsearchComponent.class)).setClient(this.client);
        camelctx.start();
        try {
            HashMap<String, String> indexedData = new HashMap<String, String>();
            indexedData.put("content", "test");
            ProducerTemplate template = camelctx.createProducerTemplate();
            template.sendBody("direct:index", indexedData);
            String indexId = (String)template.requestBody("direct:index", indexedData, String.class);
            Assert.assertNotNull((String)"Index id should not be null", (Object)indexId);
            GetResponse response = (GetResponse)template.requestBody("direct:get", (Object)indexId, GetResponse.class);
            Assert.assertNotNull((String)"getResponse should not be null", (Object)response);
        }
        finally {
            camelctx.stop();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    public void testDeleteContent() throws Exception {
        DefaultCamelContext camelctx = new DefaultCamelContext();
        camelctx.addRoutes((RoutesBuilder)new RouteBuilder(){

            public void configure() throws Exception {
                this.from("direct:index").to("elasticsearch://local?operation=INDEX&indexName=twitter&indexType=tweet");
                this.from("direct:get").to("elasticsearch://local?operation=GET_BY_ID&indexName=twitter&indexType=tweet");
                this.from("direct:delete").to("elasticsearch://local?operation=DELETE&indexName=twitter&indexType=tweet");
            }
        });
        ((ElasticsearchComponent)camelctx.getComponent("elasticsearch", ElasticsearchComponent.class)).setClient(this.client);
        camelctx.start();
        try {
            HashMap<String, String> indexedData = new HashMap<String, String>();
            indexedData.put("content", "test");
            ProducerTemplate template = camelctx.createProducerTemplate();
            template.sendBody("direct:index", indexedData);
            String indexId = (String)template.requestBody("direct:index", indexedData, String.class);
            Assert.assertNotNull((String)"Index id should not be null", (Object)indexId);
            GetResponse getResponse = (GetResponse)template.requestBody("direct:get", (Object)indexId, GetResponse.class);
            Assert.assertNotNull((String)"getResponse should not be null", (Object)getResponse);
            DeleteResponse deleteResponse = (DeleteResponse)template.requestBody("direct:delete", (Object)indexId, DeleteResponse.class);
            Assert.assertNotNull((String)"deleteResponse should not be null", (Object)deleteResponse);
            getResponse = (GetResponse)template.requestBody("direct:get", (Object)indexId, GetResponse.class);
            Assert.assertNotNull((String)"getResponse should not be null", (Object)getResponse);
            Assert.assertNull((String)"getResponse source should be null", (Object)getResponse.getSource());
        }
        finally {
            camelctx.stop();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    public void testSearchContent() throws Exception {
        DefaultCamelContext camelctx = new DefaultCamelContext();
        camelctx.addRoutes((RoutesBuilder)new RouteBuilder(){

            public void configure() throws Exception {
                this.from("direct:index").to("elasticsearch://local?operation=INDEX&indexName=twitter&indexType=tweet");
                this.from("direct:search").to("elasticsearch://local?operation=SEARCH&indexName=twitter&indexType=tweet");
            }
        });
        ((ElasticsearchComponent)camelctx.getComponent("elasticsearch", ElasticsearchComponent.class)).setClient(this.client);
        camelctx.start();
        try {
            HashMap<String, String> indexedData = new HashMap<String, String>();
            indexedData.put("content", "test");
            ProducerTemplate template = camelctx.createProducerTemplate();
            template.sendBody("direct:index", indexedData);
            HashMap<String, String> actualQuery = new HashMap<String, String>();
            actualQuery.put("content", "searchtest");
            HashMap<String, HashMap<String, String>> match = new HashMap<String, HashMap<String, String>>();
            match.put("match", actualQuery);
            HashMap<String, HashMap<String, HashMap<String, String>>> query = new HashMap<String, HashMap<String, HashMap<String, String>>>();
            query.put("query", match);
            SearchResponse searchResponse = (SearchResponse)template.requestBody("direct:search", query, SearchResponse.class);
            Assert.assertNotNull((String)"searchResponse should not be null", (Object)searchResponse);
            Assert.assertNotNull((String)"searchResponse hit count should equal 1", (Object)searchResponse.getHits().totalHits());
        }
        finally {
            camelctx.stop();
        }
    }

    private static void deleteDataDirectory() throws IOException {
        if (ElasticSearchClientProducer.DATA_PATH.toFile().isDirectory()) {
            Files.walkFileTree(ElasticSearchClientProducer.DATA_PATH, (FileVisitor<? super Path>)new SimpleFileVisitor<Path>(){

                @Override
                public FileVisitResult visitFile(Path file, BasicFileAttributes attrs) throws IOException {
                    Files.delete(file);
                    return FileVisitResult.CONTINUE;
                }

                @Override
                public FileVisitResult visitFileFailed(Path file, IOException exception) throws IOException {
                    exception.printStackTrace();
                    return FileVisitResult.CONTINUE;
                }

                @Override
                public FileVisitResult postVisitDirectory(Path dir, IOException exception) throws IOException {
                    if (exception == null) {
                        Files.delete(dir);
                    }
                    return FileVisitResult.CONTINUE;
                }
            });
        }
    }
}

