/*
 * Decompiled with CFR 0.152.
 */
package org.wildfly.camel.test.freemarker;

import java.util.HashMap;
import org.apache.camel.ProducerTemplate;
import org.apache.camel.RoutesBuilder;
import org.apache.camel.builder.RouteBuilder;
import org.apache.camel.impl.DefaultCamelContext;
import org.jboss.arquillian.container.test.api.Deployment;
import org.jboss.arquillian.junit.Arquillian;
import org.jboss.shrinkwrap.api.ShrinkWrap;
import org.jboss.shrinkwrap.api.spec.JavaArchive;
import org.junit.Assert;
import org.junit.Test;
import org.junit.runner.RunWith;
import org.wildfly.extension.camel.CamelAware;

@CamelAware
@RunWith(value=Arquillian.class)
public class FreeMarkerIntegrationTest {
    private static final String TEMPLATE_FILE = "template.ftl";

    @Deployment
    public static JavaArchive createDeployment() {
        return (JavaArchive)((JavaArchive)ShrinkWrap.create(JavaArchive.class, (String)"camel-freemarker-tests.jar")).addAsResource("freemarker/template.ftl", TEMPLATE_FILE);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    public void testFreemarkerProducer() throws Exception {
        DefaultCamelContext camelctx = new DefaultCamelContext();
        camelctx.addRoutes((RoutesBuilder)new RouteBuilder(){

            public void configure() throws Exception {
                this.from("direct:start").toF("freemarker:%s", new Object[]{FreeMarkerIntegrationTest.TEMPLATE_FILE});
            }
        });
        camelctx.start();
        try {
            HashMap<String, String> headerMap = new HashMap<String, String>();
            headerMap.put("greeting", "Hello");
            headerMap.put("name", "Kermit");
            HashMap<String, HashMap<String, String>> variableMap = new HashMap<String, HashMap<String, String>>();
            variableMap.put("headers", headerMap);
            ProducerTemplate template = camelctx.createProducerTemplate();
            String result = (String)template.requestBodyAndHeader("direct:start", null, "CamelFreemarkerDataModel", variableMap, String.class);
            Assert.assertEquals((Object)"Hello Kermit", (Object)result);
        }
        finally {
            camelctx.stop();
        }
    }
}

