/*
 * Decompiled with CFR 0.152.
 */
package org.wildfly.camel.test.hystrix;

import org.apache.camel.Expression;
import org.apache.camel.ProducerTemplate;
import org.apache.camel.RoutesBuilder;
import org.apache.camel.builder.RouteBuilder;
import org.apache.camel.impl.DefaultCamelContext;
import org.apache.camel.model.HystrixDefinition;
import org.jboss.arquillian.container.test.api.Deployer;
import org.jboss.arquillian.container.test.api.Deployment;
import org.jboss.arquillian.junit.Arquillian;
import org.jboss.arquillian.test.api.ArquillianResource;
import org.jboss.shrinkwrap.api.ShrinkWrap;
import org.jboss.shrinkwrap.api.spec.JavaArchive;
import org.jboss.shrinkwrap.api.spec.WebArchive;
import org.junit.Assert;
import org.junit.Test;
import org.junit.runner.RunWith;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.wildfly.camel.test.hystrix.subA.DelayedHttpResponseServlet;
import org.wildfly.extension.camel.CamelAware;

@CamelAware
@RunWith(value=Arquillian.class)
public class HystrixIntegrationTest {
    private static final String DELAYED_RESPONSE_WAR = "delayed-http-response.war";
    private static final Logger LOG = LoggerFactory.getLogger(HystrixIntegrationTest.class);
    @ArquillianResource
    Deployer deployer;

    @Deployment
    public static JavaArchive createDeployment() {
        return (JavaArchive)ShrinkWrap.create(JavaArchive.class, (String)"camel-hystrix-tests.jar");
    }

    @Deployment(testable=false, managed=false, name="delayed-http-response.war")
    public static WebArchive createDelayedResponseDeployment() {
        return (WebArchive)((WebArchive)ShrinkWrap.create(WebArchive.class, (String)DELAYED_RESPONSE_WAR)).addClass(DelayedHttpResponseServlet.class);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    public void testHystrixCircuitBreakerNoFallback() throws Exception {
        DefaultCamelContext camelctx = new DefaultCamelContext();
        camelctx.addRoutes((RoutesBuilder)new RouteBuilder(){

            public void configure() throws Exception {
                ((HystrixDefinition)((HystrixDefinition)this.from("direct:start").hystrix().hystrixConfiguration().executionTimeoutInMilliseconds(Integer.valueOf(5000)).end().to("undertow:http://localhost:8080/delayed-http-response/delay-me")).onFallback().setBody((Expression)this.constant("Hello Kermit"))).end();
            }
        });
        try {
            this.deployer.deploy(DELAYED_RESPONSE_WAR);
            camelctx.start();
            ProducerTemplate template = camelctx.createProducerTemplate();
            String result = (String)template.requestBody("direct:start", null, String.class);
            Assert.assertEquals((Object)"Hello World", (Object)result);
        }
        finally {
            camelctx.stop();
            this.deployer.undeploy(DELAYED_RESPONSE_WAR);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    public void testHystrixCircuitBreakerFallback() throws Exception {
        LOG.info("[wfc#1507] testHystrixCircuitBreakerFallback start: {}", (Object)System.currentTimeMillis());
        DefaultCamelContext camelctx = new DefaultCamelContext();
        camelctx.addRoutes((RoutesBuilder)new RouteBuilder(){

            public void configure() throws Exception {
                ((HystrixDefinition)((HystrixDefinition)this.from("direct:start").hystrix().hystrixConfiguration().executionTimeoutInMilliseconds(Integer.valueOf(2000)).end().to("undertow:http://localhost:8080/delayed-http-response/delay-me")).onFallback().setBody((Expression)this.constant("Hello Kermit"))).end();
            }
        });
        try {
            LOG.info("[wfc#1507] DelayedHttpResponseServlet deploy: {}", (Object)System.currentTimeMillis());
            this.deployer.deploy(DELAYED_RESPONSE_WAR);
            camelctx.start();
            ProducerTemplate template = camelctx.createProducerTemplate();
            LOG.info("[wfc#1507] ProducerTemplate.requestBody() start: {}", (Object)System.currentTimeMillis());
            String result = (String)template.requestBody("direct:start", null, String.class);
            LOG.info("[wfc#1507] ProducerTemplate.requestBody() end, result = {} : {}", (Object)result, (Object)System.currentTimeMillis());
            Assert.assertEquals((Object)"Hello Kermit", (Object)result);
        }
        finally {
            LOG.info("[wfc#1507] Camel context shutdown: {}", (Object)System.currentTimeMillis());
            camelctx.stop();
            LOG.info("[wfc#1507] DelayedHttpResponseServlet undeploy: {}", (Object)System.currentTimeMillis());
            this.deployer.undeploy(DELAYED_RESPONSE_WAR);
        }
    }
}

