/*
 * Decompiled with CFR 0.152.
 */
package org.wildfly.camel.test.jdbc;

import java.util.HashMap;
import java.util.List;
import org.apache.camel.ProducerTemplate;
import org.apache.camel.RoutesBuilder;
import org.apache.camel.builder.RouteBuilder;
import org.apache.camel.impl.DefaultCamelContext;
import org.jboss.arquillian.container.test.api.Deployment;
import org.jboss.arquillian.junit.Arquillian;
import org.jboss.shrinkwrap.api.ShrinkWrap;
import org.jboss.shrinkwrap.api.spec.JavaArchive;
import org.junit.Assert;
import org.junit.Test;
import org.junit.runner.RunWith;
import org.wildfly.extension.camel.CamelAware;

@CamelAware
@RunWith(value=Arquillian.class)
public class JDBCIntegrationTest {
    @Deployment
    public static JavaArchive createDeployment() {
        return (JavaArchive)ShrinkWrap.create(JavaArchive.class, (String)"camel-jdbc-tests.jar");
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    public void testJDBCEndpoint() throws Exception {
        DefaultCamelContext camelctx = new DefaultCamelContext();
        camelctx.addRoutes((RoutesBuilder)new RouteBuilder(){

            public void configure() throws Exception {
                this.from("direct:start").to("jdbc:java:jboss/datasources/ExampleDS");
            }
        });
        camelctx.start();
        try {
            ProducerTemplate template = camelctx.createProducerTemplate();
            List rows = (List)template.requestBody("direct:start", (Object)"select name from information_schema.users", List.class);
            Assert.assertTrue((String)"Expected at least one row returned from query", (rows.size() > 0 ? 1 : 0) != 0);
            String result = ((HashMap)rows.get(0)).get("NAME").toString();
            Assert.assertEquals((Object)"SA", (Object)result);
        }
        finally {
            camelctx.stop();
        }
    }
}

